<?php
/**
 * Category Tag Relation Model
 *
 * PHP version 5.6
 *
 * @category  Category
 * @package   Category
 * @author    Smruti ranjan Routray <soam@imprintnext.com>
 * @copyright 2021-2022 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace App\Components\Models;
/**
 * Category Tag Relation Model Class
 *
 * @category Category
 * @package  Category
 * @author   Smruti ranjan Routray <soam@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class CategoryTagRel extends \Illuminate\Database\Eloquent\Model
{
    protected $table = 'category_tag_rel';
    protected $fillable = ['category_id', 'tag_id'];
    public $timestamps = false;

    /**
     * Reverse One-to-one relationship between Category and Category-Tag
     *
     * @author soam@imprintnext.com
     * @date   28 July 2021
     * @return relationship object of Category
     */
    public function tag()
    {
        return $this->hasOne('App\Components\Models\Tag', 'xe_id', 'tag_id')
            ->select('xe_id', 'name');
    }
}
