<?php
/**
 * Quotation Payment Setting
 *
 * PHP version 5.6
 *
 * @category  Quotation_Payment_Setting
 * @package   Production_Hub
 * @author    Debashri Bhakat <debashrib@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://imprintnext.io
 */

namespace App\Components\Models;

/**
 * Quotation Payment Setting
 *
 * @category Quotation_Payment_Setting
 * @package  Production_Hub
 * @author   Debashri Bhakat <debashrib@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://imprintnext.io
 */

class QuotationPaymentSettings extends \Illuminate\Database\Eloquent\Model
{
    protected $primaryKey = 'xe_id';
    protected $table = 'quote_payment_settings';
    protected $fillable = ['store_id', 'payment_method_id', 'keyname', 'keyvalue'];
    protected $guarded = ['xe_id'];
    public $timestamps = false;
}
