<?php
/**
 * Tag's Model
 *
 * PHP version 5.6
 *
 * @category  Common_Tag
 * @package   Common
 * @author    Tanmaya Patra <tanmayap@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace App\Components\Models;

use Illuminate\Database\Eloquent\Model as Model;

/**
 * Clipart Tag
 *
 * @category Common_Tag
 * @package  Common
 * @author   Tanmaya Patra <tanmayap@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class Tag extends Model
{
    protected $primaryKey = 'xe_id';
    public $timestamps = false;
    protected $fillable = ['asset_type_id', 'store_id', 'name'];
    protected $guarded = ['xe_id'];
}
