<?php
/**
 * This is a common store component which will be used across all
 * Module-store-controllers
 *
 * PHP version 5.6
 *
 * @category  Prestashop_Store
 * @package   Store
 * @author    Radahanatha <radhanatham@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace ComponentStoreSpace\Controllers;

use App\Components\Controllers\Component;

/**
 * Store Component
 *
 * @category Prestashop_Store
 * @package  Store
 * @author   Radahanatha <radhanatham@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class StoreComponent extends Component
{
    public $webService;
    public $languageId = 0;
    public $storeId = 0;
    /**
     * Instantiate Constructor
     */
    public function __construct()
    {   
        $this->includeFile();
        $this->webService = new \PrestaShopWebservice(PS_SHOP_PATH, PS_WS_AUTH_KEY, DEBUG);
        $this->languageId = $this->webService->getLaguageId();
        $this->storeId = $this->webService->getStoreId();

    }

    public function apiCall($parameters)
    {
        $webServices = new \PrestaShopWebservice(PS_SHOP_PATH, PS_WS_AUTH_KEY, DEBUG);
        switch ($parameters['resource']) {
        case 'products':
            return  $webServices->get($parameters);
                break;
        case 'categories':
            return $webServices->get($parameters);
                break;
        case 'getAttributeCombinations':
            return $webServices->getAttributeCombinations($parameters);
                break;
        default:
            return $webServices->get($parameters);
                break;
        }
    }

    public function storeApiCall($parameters)
    {
        $webServices = new \PrestaShopWebservice(PS_SHOP_PATH, PS_WS_AUTH_KEY, DEBUG);
        switch ($parameters['resource']) {
        case 'products':
            return  $webServices->get($parameters);
                break;
        case 'categories':
            return $webServices->get($parameters);
                break;
        case 'getAttributeCombinations':
            return $webServices->getAttributeCombinations($parameters);
                break;
        default:
            return $webServices->get($parameters);
                break;
        }
    }

    private function includeFile()
    {
        include_once dirname(__FILE__) . '/../../../../../../../../../PrestaShop-webservice-lib-master/PSWebServiceLibrary.php';
    }


}
