<?php 
/**
 * Cart data Model for Big commerce
 * 
 * PHP version 5.6
 * 
 * @category    Cart data
 * @package     Cart
 * @author      Ramasankar <ramasankarm@riaxe.com>
 * @copyright   2019-2020 Riaxe Systems
 * @license     http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link        http://inkxe-v10.inkxe.io/xetool/admin
 */

 namespace App\Modules\Carts\Models;
 
/**
 * Cart data
 *
 * @category Cart data
 * @package  Cart
 * @author   Ramasankar <ramasankarm@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */

class CartData extends \Illuminate\Database\Eloquent\Model 
{
    protected $table = "bigcommerce_cart";
    protected $primaryKey = "xe_id";
    protected $guarded = ['xe_id'];
    protected $fillable = [
        'product_id',
        'variant_id',
        'cart_id',
        'line_item_id',
        'custom_design_id'
    ];
    public $timestamps = false;
}