<?php
/**
 * Manage Stiore carts
 *
 * PHP version 5.6
 *
 * @category  Carts
 * @package   Store
 * @author    Sanjeeb Dakhinaray <steve@imprintnext.com>
 * @copyright 2021-2022 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace CartStoreSpace\Controllers;

use ComponentStoreSpace\Controllers\StoreComponent;

/**
 * Store Carts Controller
 *
 * @category Carts
 * @package  Store
 * @author    Sanjeeb Dakhinaray <steve@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */

class StoreCartsController extends StoreComponent
{
    /**
     * POST: Save Cart data
     *
     * @param $request  Slim's Request object
     * @param $response Slim's Response object
     *
     * @author steve@imprintnext.com
     * @date   25 Jan 2022
     * @return json response wheather data is saved or any error occured
     */
    public function addToStoreCart($request, $response, $designId) {
        $storeResponse = [];
        $cartParam = [];
        $allPostPutVars = $request->getParsedBody();
        $settingsDetails = call_api('settings', 'GET', []);
        $action = $settingsDetails['cart_setting']['cart_edit']['cart_item_edit_setting'] 
            ? $settingsDetails['cart_setting']['cart_edit']['cart_item_edit_setting'] : 'add';
        $cartItemId = (isset($allPostPutVars['cart_item_id']) && $allPostPutVars['cart_item_id'] !='') ? $allPostPutVars['cart_item_id']: 0;
        $cartId = isset($allPostPutVars['cart_Id']) ? $allPostPutVars['cart_Id'] : ''; 
        try {
            $cartProduct = json_decode($allPostPutVars['product_data'], true);
            $cartParam = $this->createAddToCartLink($cartProduct, $designId, $cartItemId , $action, $cartId);
            $url = "";
            if (!empty($cartParam)) {
                $url = $cartParam;
            }            
            if ($url != "") {
                $storeResponse = [
                    'status' => 1,
                    'message' => message('Cart', 'saved'),
                    'url' => $url,
                ];
            } else {
                $storeResponse = [
                    'status' => 0,
                    'message' => message('Cart', 'failed'),
                ];
            }
        } catch (\Exception $e) {
            // Store exception in logs
            create_log(
                'store', 'error',
                [
                    'message' => $e->getMessage(),
                    'extra' => [
                        'module' => 'Product add to cart',
                        'controller' => 'storecomponent',
                    ],
                ]
            );
        }
        return $storeResponse;
    }

     /**
     * Bigcommerce REST API call helper function
     *
     * @param $args Carte id & line item Id
     *
     * @author steve@imprintnext.com
     * @date   15 jan 2022
     * @return return custom design Id
     */
    public function storeBigAddToCart($args){
        return $this->storeAddToCart($args);
    }
}