<?php
/**
 * Manage Color Swatches
 *
 * PHP version 5.6
 *
 * @category  Settings
 * @package   Eloquent
 * @author    Satyabrata <satyabratap@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace App\Modules\Integration\Controllers;

use App\Components\Controllers\Component as ParentController;
use App\Modules\Integration\Models\PluginSettings;

use App\Modules\Integration\Models\SalesChannelArtworkRelation;
use App\Modules\Artwork\Models\SalesChannelArtwork;
use App\Modules\Integration\Models\SalesChannel;
use App\Modules\Artwork\Controllers\ArtworkController;


/**
 * Setting Controller
 *
 * @category Class
 * @package  Setting
 * @author   Satyabrata <satyabratap@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class AmazonController extends ParentController {
    private $selling_partner_id;
    private $refreshToken;
	/**
	 * Initialize Constructor
	 */

    public function __construct()
    { 
        $pluginsObj = new PluginSettings();
        $checkRecord = $pluginsObj->where(
            ['catalog_code' => 'amazon']
        );
        $checkRecord = $checkRecord->first();
        $checkRecord = json_clean_decode($checkRecord['settings']);
        $this->refreshToken = $checkRecord['refresh_token'];
        $this->selling_partner_id = $checkRecord['selling_partner_id'];
        require_once getcwd() . '/app/Dependencies/sellingPartnerApi/sp-autoloader.php';
    }
    
    /**
     *
     * @param $request  Slim's Request object
     * @param $response Slim's Response object
     * @param $storeId   Store Id
     *
     * @author steve@imprintnext.com
     * @date   26 Oct 2022
     * @return Amazon MarketplaceList
     */
    public function getAmazonMarketplace($request, $response, $args){
        $serverStatusCode = OPERATION_OKAY;
        $jsonResponse = '{
            "status" :1,
            "marketplace":[ {
                "market_place": "Brazil",
                "country_code": "BR",
                "marketplace_id": "A2Q3Y263D00KWC"
            },
            {
                "market_place": "Canada",
                "country_code": "CA",
                "marketplace_id": "A2EUQ1WTGCTBG2"
            },
            {
                "market_place": "Mexico",
                "country_code": "MX",
                "marketplace_id": "A1AM78C64UM0Y8"
            },
            {
                "market_place": "US",
                "country_code": "US",
                "marketplace_id": "ATVPDKIKX0DER"
            },
            {
                "market_place": "UK",
                "country_code": "GB",
                "marketplace_id": "A1F83G8C2ARO7P"
            },
            {
                "market_place": "Australia",
                "country_code": "AU",
                "marketplace_id": "A39IBJ37TRP1C6"
            },
            {
                "market_place": "Japan",
                "country_code": "JP",
                "marketplace_id": "A1VC38T7YXB528"
            }
            ]
        }';
        $jsonResponse = json_decode($jsonResponse);
        return response(
			$response,
			['data' => $jsonResponse, 'status' => $serverStatusCode]
		);

    }

    /**
     *
     * @param $request  Slim's Request object
     * @param $response Slim's Response object
     * @param Marketplace Id   Store Id
     *
     * @author steve@imprintnext.com
     * @date   26 Oct 2022
     * @return Amazon Product Category List
     */
	public function getAmazonCategory($request, $response, $args)
    {
        $serverStatusCode = OPERATION_OKAY;
        $marketPlaceId = $request->getQueryParam('marketplace_id') ? $request->getQueryParam('marketplace_id') : 'ATVPDKIKX0DER';        
        $endPointObj = new \SellingPartnerApi\Endpoint();
        $endPoint = $endPointObj->getByMarketplaceId($marketPlaceId , AMAZON_SANDBOX);
        
        $amazonData = $this->getAmazonSettings($request, $response, $args);
        if ($amazonData == 'LWACLIENTSECRET Expire') {
            $jsonResponse = ["status" => 0, "message" => $amazonData];
            $serverStatusCode = 400;
            return response(
                $response,
                ['data' => $jsonResponse, 'status' => $serverStatusCode]
            );
        }

        $amazonConfig = new \SellingPartnerApi\Configuration([
		    "lwaClientId" => $amazonData['LWACLIENTID'],
		    "lwaClientSecret" => $amazonData['LWACLIENTSECRET'],
		    "lwaRefreshToken" => $this->refreshToken,
		    "awsAccessKeyId" => $amazonData['AWSACCESSKEYID'],
		    "awsSecretAccessKey" => $amazonData['AWSSECRETACCESSKEY'],
		    "roleArn" => $amazonData['AWSROLEARN'],
		    "endpoint" => $endPoint  // or another endpoint from lib/Endpoints.php
		]);

        $selectedCategory = [
            'APPAREL', 'APPAREL_BELT', 'APPAREL_GLOVES', 'APPAREL_HEAD_NECK_COVERING', 'SOCKS', 'BOTTLE', 'BANNER', 'BABY_COSTUME', 'APRON', 'ACCESSORY', 'ADULT_COSTUME','LUGGAGE'
        ];

		$api = new \SellingPartnerApi\Api\ProductTypeDefinitionsApi($amazonConfig);
		$result = $api->searchDefinitionsProductTypes($marketPlaceId);
        $result = json_clean_decode($result, true);
        
        $data = [];
        $productTypes = $result['productTypes'];
        foreach ($productTypes as $productType) {
            if (in_array($productType['name'], $selectedCategory)) {
                $data[] = [
                    "id" => '',
                    "name" => $productType['name'],
                    "slug" => $productType['name'],
                    "parent_id" => 0,
                    "show_in_tool" => false
                ];
            }
        }
        $jsonResponse = ["status"=> 1,"data" => $data];

        return response(
			$response,
			['data' => $jsonResponse, 'status' => $serverStatusCode]
		);
	}

    /**
     *
     * @param $request  Slim's Request object
     * @param $response Slim's Response object
     * @param Marketplace Id   Store Id
     *
     * @author steve@imprintnext.com
     * @date   26 Oct 2022
     * @return Create New Product In amazon marketplace
     */
    public function addNewAmazonProduct($request, $response, $args){
        $serverStatusCode = OPERATION_OKAY;
        $jsonResponse = [
            "status"=> 0,
            "message" => 'Product Create Failed'
        ];

        $status = 0;

        $getPostData = $request->getParsedBody();
        $artworkId = $getPostData['artwork_id'];
        $sku = $getPostData['sku'];
        $ref_id = $this->getReffIdFromArtworkId($artworkId);

        // default market place = US (ATVPDKIKX0DER)
        $marketPlaceId = isset($getPostData['marketplace_id']) ? $getPostData['marketplace_id'] : 'ATVPDKIKX0DER';
        $productData = json_clean_decode($getPostData['data'], true);

        $salesChannelId = $this->getSalesChannelId("Amazon");
        $salesChannelRelObj = new SalesChannelArtworkRelation();
        $checkRecord = $salesChannelRelObj->where([
            'artwork_id' => $artworkId,
            "sales_channel_id" => $salesChannelId
        ]);

        if ($checkRecord->count() == 0) {
            $endPointObj = new \SellingPartnerApi\Endpoint();
            $endPoint = $endPointObj->getByMarketplaceId($marketPlaceId , AMAZON_SANDBOX);

            $amazonData = $this->getAmazonSettings($request, $response, $args);
            if ($amazonData == 'LWACLIENTSECRET Expire') {
                $jsonResponse = ["status" => 0, "message" => $amazonData];
                $serverStatusCode = 400;
                return response(
                    $response,
                    ['data' => $jsonResponse, 'status' => $serverStatusCode]
                );
            }

            //$amazonData = json_clean_decode($amazonData, true);
            $amazonConfig = new \SellingPartnerApi\Configuration([
                "lwaClientId" => $amazonData['LWACLIENTID'],
                "lwaClientSecret" => $amazonData['LWACLIENTSECRET'],
                "lwaRefreshToken" => $this->refreshToken,
                "awsAccessKeyId" => $amazonData['AWSACCESSKEYID'],
                "awsSecretAccessKey" => $amazonData['AWSSECRETACCESSKEY'],
                "roleArn" => $amazonData['AWSROLEARN'],
                "endpoint" => $endPoint  // or another endpoint from lib/Endpoints.php
            ]);

            //  $api = new \SellingPartnerApi\Api\ProductTypeDefinitionsApi($amazonConfig);
            //  $result = $api->getDefinitionsProductTypeWithHttpInfo("APPAREL", $marketPlaceId);

            $artworkObj = new ArtworkController();
            $jsonData = $artworkObj->getSVGFile($ref_id, "marketplace_artworks");
            $colorProductImageUrl = [];
            if(isset($jsonData['color_product_image_url'])){
                $colorProductImageUrl = $jsonData['color_product_image_url'];
                $demoImageUrl = $colorProductImageUrl[0]['sides'][0];
                if (strpos($demoImageUrl, 's3.amazonaws.com') === false) {
                    $params = [
                        'image_url' => $colorProductImageUrl
                    ];
                    $test = false;
                    $isCatalog = false;
                    $s3Data = api_call_by_curl($params, CATALOG_API_URL . 'integration/amazon/public/getImageArrays3', $test, $isCatalog);
                    $colorProductImageUrl =  $s3Data;
                }
            }

            $productName = $productData['name'];
            $productPrice =  number_format((float)$productData['price'], 2, '.', '');
            $productQuantity = $productData['quantity'];
            $productDescription = $productData['description'];
            $productShortDescription = $productData['short_description'];
            $productType = $productData['type'];
            $createdDate = date('Y-m-d H:i:s');
                
            $sellerId = $this->selling_partner_id;
            $languageTag = "en_US";


            $productCategory = $productData['categories'][0]['category_name'];
            $amazonProductJsonPath = ASSETS_PATH_W . "amazon_category/" . strtolower($productCategory) . ".json";

            $amazonJson = file_get_contents($amazonProductJsonPath);
            $amazonJson = str_replace("MARKETPLACE", $marketPlaceId, $amazonJson);
            $amazonJson = str_replace("en_US", $languageTag, $amazonJson);
            $amazonJson = str_replace("PRODUCTPRICE", $productPrice, $amazonJson);
            
            $attributeSimple = json_decode($amazonJson);
            //$attributeSimple->main_product_image_locator[0]->media_location = $amazonProductImage;

            $defaultImage =  $colorProductImageUrl[0]['sides'][0];
            $attributeSimple->main_product_image_locator[0]->media_location = $defaultImage;

            $attributeSimple->item_name[0]->value =  $productName;
            $attributeSimple->bullet_point[0]->value =  $productShortDescription;
            if (isset($attributeSimple->item_type_name)) {
                $attributeSimple->item_type_name[0]->value = $productName;
            }

            $attributeSimple->product_description[0]->value = $productDescription;
            $attributeSimple->fulfillment_availability[0]->quantity = $productQuantity;
            $attributeSimple->child_parent_sku_relationship[0]->parent_sku = '';
            $attribute = $productData['attributes'];
            $colorArray = [];
            $sizeArray = [];
            
            foreach ($attribute as $attrValue) {
                if (strtolower($attrValue['attribute_name']) == 'size') {
                    $defaultSize = $attrValue['attribute_options'][0];
                    $sizeArray = $attrValue['attribute_options'];
                }
                if (strtolower($attrValue['attribute_name']) == 'color') {
                    $defaultColor = $attrValue['attribute_options'][0];
                    $colorArray = $attrValue['attribute_options'];
                }
            }

            $colors = array_column($colorProductImageUrl, 'name');

            $attributeSimple->color[0]->value = $defaultColor ;
            $attributeSimple->size[0]->value = $defaultSize ;
            $issueLocale = "en_US";
            $amazonArgs = [
                'sku' => $sku,
                'productCategory' => $productCategory,
                'attributeSimple' => $attributeSimple,
                'sellerId' =>  $sellerId,
                'marketPlaceId' =>  $marketPlaceId,
                'issueLocale' => $issueLocale,
                'artworkId' => $artworkId,
                'salesChannelId' => $salesChannelId,
                'createdDate' => $createdDate,
                'amazonConfig' => $amazonConfig
            ];
            if ($productType == 'simple') {
                $result =  $this->createAmazonSimpleProduct($amazonArgs);
            } else {
                $result =  $this->createAmazonParentProduct($amazonArgs);
                $parentSku = $sku;
                $amazonVariant = [];
                $varKey = 0;
                
                foreach ($colorArray as $colorKey => $colorValue) {
                    $variantPredecoImage = [];
                    if (array_search($colorValue, $colors) !== false) {
                        $row_index = array_search($colorValue, $colors);
                        $variantPredecoImage = $colorProductImageUrl[$row_index]['sides'];
                    }
                    if(!empty($variantPredecoImage)){
                        $varintDefaultImage = $variantPredecoImage[0];
                    }else{
                        $varintDefaultImage = $defaultImage ;
                    }
                    $attributeSimple->main_product_image_locator[0]->media_location = $varintDefaultImage;
                    
                    // Add side images for 1st variants only
                    if($colorKey == 0){
                        $im = 1;
                        foreach ($variantPredecoImage as $imageValue) {
                            $keyss = "other_product_image_locator_" . $im;
                            if ($im <= 7) {
                                $attributeSimple->$keyss[] = (object)['media_location' => $imageValue, 'marketplace_id' => $marketPlaceId];
                            }
                            $im = $im + 1;
                        }
                    }

                    foreach ($sizeArray as $sizeValue) {
                        $varKey = $varKey+1;
                        $attributeSimple->color[0]->value = $colorValue ;
                        $attributeSimple->size[0]->value = $sizeValue;
                        $attributeSimple->child_parent_sku_relationship[0]->child_relationship_type = "variation" ;
                        $attributeSimple->child_parent_sku_relationship[0]->parent_sku = $parentSku ;
                        
                        $variationSku = $parentSku."-".$varKey;
                        $variantArray = ['paren_sku' => $parentSku ,"variantSku" => $variationSku,'quantity' => $productQuantity];
                        $variantName = $productName." ". $sizeValue." ". $colorValue ;
                        $attributeSimple->item_name[0]->value =  $variantName ;
                        $variantResult = $this->addNewAmazonProductVariation($marketPlaceId, $productCategory, $variantArray, $attributeSimple,$amazonConfig);
                        $variantResult['name'] = $variantName;
                        $amazonVariant[] = $variantResult;
                    }
                }
            }
            if (!empty($amazonVariant)) {
                $result['variant'] = $amazonVariant;
            }
            if ($result['status'] == 'ACCEPTED') {
                $status = 1;
            } else {
                $status = 0;
            }
            
            $jsonResponse = ["status" => $status, "data" => $result];
        } else {
            $jsonResponse = ["status"=> $status,"message" => 'Failed Sku already exist'];
        }
        return response(
			$response,
			['data' => $jsonResponse, 'status' => $serverStatusCode]
		);
    }

  /**
     *
     * @param $request  Slim's Request object
     * @param $response Slim's Response object
     * @param Marketplace Id   Store Id
     *
     * @author steve@imprintnext.com
     * @date   26 Oct 2022
     * @return Amazon marketplace order list
     */
    public function getAllAmazonOrders($request, $response, $args)
    {
        $serverStatusCode = OPERATION_OKAY;
        $marketPlaceId = $request->getQueryParam('marketplace_id') ? $request->getQueryParam('marketplace_id') : 'ATVPDKIKX0DER';

        $searchName = $request->getQueryParam('name') ? $request->getQueryParam('name') : false;

        $endPointObj = new \SellingPartnerApi\Endpoint();
        $endPoint = $endPointObj->getByMarketplaceId($marketPlaceId , AMAZON_SANDBOX);

        $amazonData = $this->getAmazonSettings($request, $response, $args);
        if ($amazonData == 'LWACLIENTSECRET Expire') {
            $jsonResponse = ["status" => 0, "message" => $amazonData];
            $serverStatusCode = 400;
            return response(
                $response,
                ['data' => $jsonResponse, 'status' => $serverStatusCode]
            );
        }
        
        $amazonConfig = new \SellingPartnerApi\Configuration([
		    "lwaClientId" => $amazonData['LWACLIENTID'],
		    "lwaClientSecret" => $amazonData['LWACLIENTSECRET'],
		    "lwaRefreshToken" => $this->refreshToken,
		    "awsAccessKeyId" => $amazonData['AWSACCESSKEYID'],
		    "awsSecretAccessKey" => $amazonData['AWSSECRETACCESSKEY'],
		    "roleArn" => $amazonData['AWSROLEARN'],
		    "endpoint" => $endPoint  // or another endpoint from lib/Endpoints.php
		]);

        $api = new \SellingPartnerApi\Api\OrdersApi($amazonConfig);
        $result = $api->getOrders([$marketPlaceId], '2020-01-01');
        $result = json_clean_decode($result, true);
        $result = $result['payload']['Orders'];
        $orderData = [];
        foreach ($result as $value) {
            if(strpos($value['AmazonOrderId'],$searchName) !== false || !$searchName){
                $orderData[] = [
                    "id" => $value['AmazonOrderId'],
                    "order_number" => $value['AmazonOrderId'],
                    "customer_first_name" => $buyerInfo,
                    "customer_last_name" => '',
                    "created_date" => $value['PurchaseDate'],
                    "currency" => $orderTotal['CurrencyCode'],
                    "total_amount" => $orderTotal['Amount'],
                    "order_total_quantity" => $totalItem ,
                    "report" => "Order Placed Successfully",
                    "status" => $value['OrderStatus'],
                ]; 
            }            
            $buyerInfo = $value['BuyerInfo']['BuyerEmail'] ?$value['BuyerInfo']['BuyerEmail']:'' ;
            $orderTotal = $value['OrderTotal'];
            $totalItem = $value['NumberOfItemsShipped']+$value['NumberOfItemsUnshipped'];

        }
        $jsonResponse = [
            "status" => 1,
            "total_records" => sizeof($orderData),
            "records" => sizeof($orderData),
            "data" => $orderData,

        ];

        return response(
			$response,
			['data' => $jsonResponse, 'status' => $serverStatusCode]
		);
    }

    /**
     *
     * @param $request  Slim's Request object
     * @param $response Slim's Response object
     * @param Marketplace Id   Store Id
     *
     * @author steve@imprintnext.com
     * @date   26 Oct 2022
     * @return Amazon marketplace order Details
     */
    public function getAmazonOrderDetail($request, $response, $args)
    {
        $serverStatusCode = OPERATION_OKAY;
        $marketPlaceId = $request->getQueryParam('marketplace_id') ? $request->getQueryParam('marketplace_id') : 'ATVPDKIKX0DER';
        $orderId =  $args['order_id'];
        $endPointObj = new \SellingPartnerApi\Endpoint();
        $endPoint = $endPointObj->getByMarketplaceId($marketPlaceId , AMAZON_SANDBOX);

        $amazonData = $this->getAmazonSettings($request, $response, $args);
        if ($amazonData == 'LWACLIENTSECRET Expire') {
            $jsonResponse = ["status" => 0, "message" => $amazonData];
            $serverStatusCode = 400;
            return response(
                $response,
                ['data' => $jsonResponse, 'status' => $serverStatusCode]
            );
        }
        
        $amazonConfig = new \SellingPartnerApi\Configuration([
		    "lwaClientId" => $amazonData['LWACLIENTID'],
		    "lwaClientSecret" => $amazonData['LWACLIENTSECRET'],
		    "lwaRefreshToken" => $this->refreshToken,
		    "awsAccessKeyId" => $amazonData['AWSACCESSKEYID'],
		    "awsSecretAccessKey" => $amazonData['AWSSECRETACCESSKEY'],
		    "roleArn" => $amazonData['AWSROLEARN'],
		    "endpoint" => $endPoint  // or another endpoint from lib/Endpoints.php
		]);

        $api = new \SellingPartnerApi\Api\OrdersApi($amazonConfig);
        $catalogApi = new \SellingPartnerApi\Api\CatalogApi($amazonConfig);

        // Get Order Detail from amazon seller api
        $orderDetails = $api->getOrder($orderId);
        $orderDetails = json_clean_decode($orderDetails, true);
        $orderDetails = $orderDetails['payload'];

        $shippingAddress = $orderDetails['ShippingAddress'];
        $paymentMethod =  $orderDetails["PaymentMethodDetails"];
        $buyerInfo = $orderDetails['BuyerInfo'];
        
        // Get Order item list from amazon seller api
        $orderItems = $api->getOrderItems($orderId);
        $orderItems = json_clean_decode($orderItems, true);
       

        $amazonOrderItems =  $orderItems['payload']['OrderItems'];
        $orderDetails['OrderItems'] = $amazonOrderItems;


        $orderDetailsArray['amazon_transaction'] = [
            "payment" => $paymentMethod
        ];
        $orderItem = [];
        $artworkObj = new ArtworkController();

        $totalItemPrice = 0;
        $itemPackageWeightUnit ='';
        $itemPackageWeight = 0;
        foreach ($amazonOrderItems as $value) {
            $asin = $value['ASIN'];
            $orderItemId = $value['OrderItemId'];
            $quantity = $value['ProductInfo']['NumberOfItems'];

            // Get Order Item Detail from amazon seller api
            $itemDetails = $catalogApi->getCatalogItem($asin, $marketPlaceId,["images,summaries","attributes"]);
            $itemDetails = json_clean_decode($itemDetails, true);
            
            $price = $itemDetails['attributes']['list_price'][0]['value'];
            $totalItemPrice +=  $price;
            $attributes = $itemDetails['attributes'];
            $itemPackageWeightUnit = $attributes['item_package_weight'][0]['unit'];
            $itemPackageWeight += $attributes['item_package_weight'][0]['value'];
            $iteamImage = $itemDetails['images'][0]['images'];
            $iteamsummaries = $itemDetails['summaries'][0];
            
            $sku = $value['SellerSKU'];
            $refId = '';
            $skuData = base64_decode($sku);
            $previewImage = [];
            $imgVar = '';
            foreach ($iteamImage as $imageFile) {
                if($imageFile['variant'] != $imgVar){
                    $previewImage[] = [
                        'src' => $imageFile['link'],
                        'thumbnail' => $imageFile['link'],
                    ];
                    $imgVar =  $imageFile['variant'];
                }
                
            }
            if(strpos($skuData, 'IMP-') !== false){
                $skuData = explode("-", $skuData);
                $refId =  $skuData[1];
                $jsonData = $artworkObj->getCaptureImages($request, $refId, true);

                $decorationSettingsData = [];
                foreach ($jsonData['sides'] as $decorationKey => $woFilesides) {
                    $decorationSettingsData[$decorationKey] = 
                    [
                        "is_design" => $woFilesides['is_designed'],
                        "name" => $woFilesides["side_name"],
                        "configurator" => [],
                        "stickerInfo" => [],
                        "decoration_data"=> []
                    ];
                    if ($woFilesides['is_designed'] == 1) {
                        $profile = $woFilesides["print_area"]['bound_0'];
                        $svg_artwork_url = ASSETS_PATH_R.MARKETPLACE_ARTWORK_FOLDER.$refId."/side_1/Layer_0_side_1_".$refId.".svg" ;
                        $png_artwork_url = ASSETS_PATH_R.MARKETPLACE_ARTWORK_FOLDER.$refId."/side_1/Layer_0_side_1_".$refId.".png" ;
                        $decorationSettingsData[$decorationKey] = [
                            "is_design" => $woFilesides['is_designed'],
                            "name" => $woFilesides["side_name"],
                            "configurator" => [],
                            "stickerInfo" => [],
                            "decoration_data" => [
                                [
                                    
                                    "decoration_name" => $woFilesides["side_name"],
                                    "print_area_id" => $profile['print_area']['id'],
                                    "print_area_name" => $profile['print_area']['name'],
                                    "print_profile_id" => $profile['print_method_id'],
                                    "print_profile_name" => $profile['print_method_name'],
                                    "print_unit" => $woFilesides["print_unit"],
                                    "print_area_height" => $profile['print_area']['height'],
                                    "print_area_width" => $profile['print_area']['width'],
                                    "design_width" => isset($profile['design_width']) ? $profile['design_width'] : "",
                                    "design_height" => isset($profile['design_height']) ? $profile['design_height'] : "",
                                    "svg_artwork_url" => $svg_artwork_url,
                                    "png_url" => $png_artwork_url,
                                    "used_colors" => $profile["used_colors"],
                                    "used_patterns" => [],
                                    "x_location" => 0,
                                    "y_location" => 0,
                                    "rotate" => true
                                ]
                            ]
                        ];
                    }
                }

            }
            $downloadKey =  base64_encode("IMP-".$refId);
            $orderItem[] = [
                "id" => $orderItemId,
                "product_id" => $value['SellerSKU'],
                "variant_id" => $value['SellerSKU'],
                "name" => $value['Title'],
                "productname" => $value['Title'],
                "price" => $price,
                "quantity" => $quantity,
                "total" => $price,
                "sku" => $value['SellerSKU'],
                "custom_design_id" => $refId,
                "ref_id" => $refId,
                "images" => $previewImage,
                "line_items" => [
                    [
                        "id" => $value['OrderItemId'],
                        "product_id" => $value['SellerSKU'],
                        "name" => $value['Title'],
                        "price" => $price,
                        "quantity" => $quantity,
                        "total" => $price,
                        "sku" => $value['SellerSKU'],
                        "custom_design_id" => $refId,
                        "ref_id" => $refId,
                        "download_key" => $downloadKey,
                        "size" =>  $iteamsummaries['sizeName'],
                        "color" => $iteamsummaries['colorName'],
                        "images" => $previewImage
                    ]
                ],
                "product_name" => $value['Title'],
                "product_description" => $value['Title'],
                "productDecorationSettingData" => null,
                "variableDecorationSize" => "",
                "variableDecorationUnit" => "",
                "configurator_svg_info" => null,
                "decoration_settings_data" => $decorationSettingsData
            ];
        }

        $orderDetailsArray = [
            "id" => $orderDetails['AmazonOrderId'],
            "order_number" => $orderDetails['AmazonOrderId'],
            "customer_first_name" => $buyerInfo['BuyerEmail'],
            "customer_last_name" => "",
            "customer_email" => $buyerInfo['BuyerEmail'],
            "customer_id" => '',
            "created_date" => $orderDetails['PurchaseDate'],
            "total_amount" => $totalItemPrice,
            "total_tax" => number_format($orderDetails['OrderTotal']['Amount'] - $totalItemPrice, 2, '.', ''),
            "total_shipping" => 0,
            "total_discounts" => 0,
            "currency" => $orderDetails['OrderTotal']['CurrencyCode'],
            "note" => "",
            "status" => $orderDetails['OrderStatus'],
            "total_orders" => sizeof($orderDetails['OrderItems']),
            "payment" => $paymentMethod,
            "store_url" => "https://amazon.com",
            "weight_unit" => $itemPackageWeightUnit,
            "weight" => $itemPackageWeight,
            "po_status" => 0,
            "production_status" => 0,
            "barcode_url" => "#",
            "po_status_name" => "",
            "po_status_color" => "",
            "notes" => [],
        ];

        $orderDetailsArray['billing'] = [
            "first_name" => $buyerInfo['BuyerEmail'],
            "last_name" => $buyerInfo['BuyerEmail'],
            "company" => "",
            "address_1" => "",
            "address_2" => "",
            "city" => "",
            "state" => "",
            "postcode" => "",
            "country" => "",
            "country_code" => "",
            "email" => $buyerInfo['BuyerEmail'],
            "phone" => ''
        ];

        $orderDetailsArray['amazon_shipping'] = [
            "first_name" => $buyerInfo['BuyerEmail'],
            "last_name" => '',
            "company" => "",
            "address_1" => "",
            "address_2" => "",
            "city" => $shippingAddress['City'],
            "state" => $shippingAddress['StateOrRegion'],
            "postcode" => $shippingAddress['PostalCode'],
            "country" => $shippingAddress['CountryCode'],
            "country_code" => $shippingAddress['CountryCode'],
            "email" => $buyerInfo['BuyerEmail'],
            "phone" => ''
        ];
        $orderDetailsArray['orders'] = $orderItem;

        $jsonResponse =  [
            "status" => 1,
            "total_records" => 1,
            "data" => $orderDetailsArray
        ];
        return response($response,
			['data' => $jsonResponse, 'status' => $serverStatusCode]
		);
    }

    private function getArtworkIdFromReffId($ref_id){
        $artworkObj = new SalesChannelArtwork();
        $checkRecord = $artworkObj->where(['ref_id' => $ref_id]);
        $checkRecord = $checkRecord->first();
        return($checkRecord['xe_id']);
    }

    private function getSalesChannelId($salesChannelName){
        $artworkObj = new SalesChannel();
        $checkRecord = $artworkObj->where(['channel_name' => $salesChannelName]);
        $checkRecord = $checkRecord->first();
        return($checkRecord['xe_id']);
    }


    /**
     *
     * @param $request  Slim's Request object
     * @param $response Slim's Response object
     * @param Marketplace Id   Store Id
     *
     * @author steve@imprintnext.com
     * @date   20 Apr 2023
     * @return Create Variantion product.
     */
    private function createAmazonSimpleProduct($amazonArgs)
    {
        $sku = $amazonArgs['sku'];
        $productCategory = $amazonArgs['productCategory'];
        $attributeSimple = $amazonArgs['attributeSimple'];
        $sellerId = $amazonArgs['sellerId'];
        $marketPlaceId = $amazonArgs['marketPlaceId'];
        $issueLocale = $amazonArgs['issueLocale'];
        $artworkId = $amazonArgs['artworkId'];
        $salesChannelId = $amazonArgs['salesChannelId'];
        $createdDate = $amazonArgs['createdDate'];
        $amazonConfig = $amazonArgs['amazonConfig'];


        $apiInstance = new \SellingPartnerApi\Api\ListingsApi($amazonConfig);
        $productQuantity = $attributeSimple->fulfillment_availability[0]->quantity;
        $listingArr = array(
            "sku" => $sku,
            "product_type" => $productCategory,
            "requirements" => "LISTING",
            "attributes" => $attributeSimple,
            "fulfillmentAvailability" => array(array("fulfillmentChannelCode" => "DEFAULT", "quantity" => $productQuantity))
        );

        $body = new \SellingPartnerApi\Model\Listings\ListingsItemPutRequest($listingArr);

        try {
            $result = $apiInstance->putListingsItem($sellerId, $sku, $marketPlaceId, $body, $issueLocale);
            $result = json_clean_decode($result, true);
        } catch (\Exception $e) {
            echo 'Exception when calling ListingsApi->putListingsItem: ', $e->getMessage(), PHP_EOL;
        }
        $sellerData = [
            "artwork_id" => $artworkId,
            "sales_channel_id" => $salesChannelId,
            "product_id" => '',
            "created_date" => $createdDate
        ];
        $salesChannelRelObj = new SalesChannelArtworkRelation($sellerData);
        $salesChannelRelObj->save();
        return  $result;
    }

    /**
     *
     * @param $request  Slim's Request object
     * @param $response Slim's Response object
     * @param Marketplace Id   Store Id
     *
     * @author steve@imprintnext.com
     * @date   20 Apr 2023
     * @return Create Variantion product.
     */
    private function createAmazonParentProduct($amazonArgs)
    {
        $sku = $amazonArgs['sku'];
        $productCategory = $amazonArgs['productCategory'];
        $attributeSimple = clone $amazonArgs['attributeSimple'];

        $attributeConfig = $attributeSimple;

        $sellerId = $amazonArgs['sellerId'];
        $marketPlaceId = $amazonArgs['marketPlaceId'];
        $issueLocale = $amazonArgs['issueLocale'];
        $artworkId = $amazonArgs['artworkId'];
        $salesChannelId = $amazonArgs['salesChannelId'];
        $createdDate = $amazonArgs['createdDate'];
        $amazonConfig = $amazonArgs['amazonConfig'];

        unset($attributeConfig->color);
        unset($attributeConfig->size);

        $productQuantity = $attributeConfig->fulfillment_availability[0]->quantity;
        $attributeConfig->parentage_level[0]->value = 'Parent';

        $attributeConfig->parentage_level[0]->marketplace_id = $marketPlaceId;
        $attributeConfig->child_parent_sku_relationship[0]->child_relationship_type = "variation";

        $apiInstance = new \SellingPartnerApi\Api\ListingsApi($amazonConfig);
        $listingArr = array(
            "sku" => $sku,
            "product_type" => $productCategory,
            "requirements" => "LISTING",
            "attributes" => $attributeConfig,
            "fulfillmentAvailability" => array(array("fulfillmentChannelCode" => "DEFAULT", "quantity" => $productQuantity))
        );

        $body = new \SellingPartnerApi\Model\Listings\ListingsItemPutRequest($listingArr);

        try {
            $result = $apiInstance->putListingsItem($sellerId, $sku, $marketPlaceId, $body, $issueLocale);
            $result = json_clean_decode($result, true);
        } catch (\Exception $e) {
            echo 'Exception when calling ListingsApi->putListingsItem: ', $e->getMessage(), PHP_EOL;
        }
        $sellerData = [
            "artwork_id" => $artworkId,
            "sales_channel_id" => $salesChannelId,
            "product_id" => '',
            "created_date" => $createdDate
        ];
        $salesChannelRelObj = new SalesChannelArtworkRelation($sellerData);
        $salesChannelRelObj->save();
        sleep(1);
        return  $result;
    }

    /**
     *
     * @param $request  Slim's Request object
     * @param $response Slim's Response object
     * @param Marketplace Id   Store Id
     *
     * @author steve@imprintnext.com
     * @date   26 Oct 2022
     * @return Create Variantion product.
     */

    private function addNewAmazonProductVariation($marketPlaceId, $productCategory, $variantArray, $attributeSimple, $amazonConfig)
    {
        $parentSku = $variantArray['paren_sku'];
        $variationSku = $variantArray['variantSku'];
        $productQuantity = $variantArray['quantity'];

        $apiInstance = new \SellingPartnerApi\Api\ListingsApi($amazonConfig);

        $sellerId = $this->selling_partner_id;
        $attributeSimple->child_parent_sku_relationship[0]->child_relationship_type = "variation";
        $attributeSimple->child_parent_sku_relationship[0]->parent_sku = $parentSku;

        $issueLocale = "en_US";
        $attributeSimple->parentage_level[0]->value = 'child';

        $listingArr = array(
            "sku" => $variationSku,
            "product_type" => $productCategory,
            "requirements" => "LISTING",
            "attributes" => $attributeSimple,
            "fulfillmentAvailability" => array(array("fulfillmentChannelCode" => "DEFAULT", "quantity" => $productQuantity))
        );
        $body = new \SellingPartnerApi\Model\Listings\ListingsItemPutRequest($listingArr);
        $result = $apiInstance->putListingsItem($sellerId, $variationSku, $marketPlaceId, $body, $issueLocale);
        return json_clean_decode($result, true);
    }

    private function getReffIdFromArtworkId($artworkId){
        $artworkObj = new SalesChannelArtwork();
        $checkRecord = $artworkObj->where(['xe_id' => $artworkId]);
        $checkRecord = $checkRecord->first();
        return($checkRecord['ref_id']);
    }


     /**
     *
     * @param $request  Slim's Request object
     * @param $response Slim's Response object
     * @param Marketplace Id   Store Id
     *
     * @author steve@imprintnext.com
     * @date   8th Aug 2023
     * @return Get amazon settings.
     */

    private function getAmazonSettings($request, $response, $args){
        $getStoreDetails = get_store_details($request);
        $storeId= $getStoreDetails['store_id'];
        $amazonSettingJsonPath = path('abs', 'setting') . 'stores/' . $storeId . "/amazon.json";
        if(file_exists($amazonSettingJsonPath)){
            $amazonSettingJson = json_clean_decode(file_get_contents($amazonSettingJsonPath),true);
            $time = $amazonSettingJson['Rotation_Deadline'];
            if(time() < strtotime($time)){
                return  $amazonSettingJson;
            }else{
                //GET DATA FROM CENTRAL SERVER                
                $amazonSettingJson = '';
            }
        }else{
            //GET DATA FROM CENTRAL SERVER
            $amazonSettingJson = '';
        }

        if( $amazonSettingJson == ''){
            $params = [];
            $test = false;
            $isCatalog = false;
            $amazonSettingJson = api_call_by_curl($params, CATALOG_API_URL . 'integration/amazon/public/getAmazonSettings', $test, $isCatalog);
            file_put_contents($amazonSettingJsonPath, json_encode($amazonSettingJson) );
            
            $amazonSettingJson = json_clean_decode(file_get_contents($amazonSettingJsonPath),true);

            //Check new time from central server data
            $time = $amazonSettingJson['Rotation_Deadline'];
            if(time() < strtotime($time)){
                return  $amazonSettingJson;
            }else{
                //GET DATA FROM CENTRAL SERVER
                $params = ["msg" => "LWACLIENTSECRET Expire"];
                api_call_by_curl($params, CATALOG_API_URL . 'integration/amazon/public/sendServiceNotification', $test, $isCatalog);
                return 'LWACLIENTSECRET Expire';
            }

        }
        
        return $amazonSettingJson; 
    }

}