<?php
/**
 * Manage Customer
 *
 * PHP version 5.6
 *
 * @category  Customers
 * @package   Eloquent
 * @author    Satyabrata <satyabratap@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */

namespace MultiStoreStoreSpace\Controllers;

use CommonStoreSpace\Controllers\StoreController;

/**
 * Customer Controller
 *
 * @category Class
 * @package  Customer
 * @author   Satyabrata <soumyas@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class StoreMultiStoreController extends StoreController {
	
	/**
	 * Instantiate Constructor
	 */
	public function __construct() {
		parent::__construct();
	}
	/**
	 * GET: Get all blogs
	 *
	 * @param $request  Slim's Request object
	 * @param $response Slim's Response object
	 * @param $args     Slim's Arguments
	 *
	 * @author soumyas@riaxe.com
	 * @date   5 Nov 2019
	 * @return Array
	 */

	public function getAllStores() {
		return $this->requestGet('multi_store');
		
	}
	/**
	 * POST: Create a CMS pagew
	 *
	 * @param $storeId
	 * @author soumyas@riaxe.com
	 * @date   5 Nov 2019
	 * @return int
	 */
	public function createCmsPage($storeId) {
		$status = 0;
		if (is_multisite()) {
			switch_to_blog($storeId);
		}
		$title = "Product Designer";
		if( null == get_page_by_title( $title ) )  {
			global $user_ID;
			$xepath = get_site_url();
			$inkXEDir = get_option('inkxe_dir');
			if (!$inkXEDir) {
				$inkXEDir = "designer";
			}
			$designerURL = $xepath . "/" . $inkXEDir . "/index.html"; 
			$page = array();
			$page['post_type']    = 'page';
			$page['post_content'] = '<iframe id="tshirtIFrame" style="width: 100%; height: 776px; margin-top: 50px; border: 1px solid #e5e5e5; box-shadow: 0px 0px 24px -6px rgba(0,0,0,0.1);" src="'.$designerURL.'" frameborder="0" scrolling="no"><span data-mce-type="bookmark" style="display: inline-block; width: 0px; overflow: hidden; line-height: 0;" class="mce_SELRES_start">﻿</span><span data-mce-type="bookmark" style="display: inline-block; width: 0px; overflow: hidden; line-height: 0;" class="mce_SELRES_start">﻿</span><span data-mce-type="bookmark" style="display: inline-block; width: 0px; overflow: hidden; line-height: 0;" class="mce_SELRES_start">﻿</span></iframe>';
			$page['post_parent']  = 0;
			$page['post_author']  = $user_ID;
			$page['post_status']  = 'publish';
			$page['post_title']   = $title;
			remove_all_filters("content_save_pre");
			$pageid = wp_insert_post ($page);
			if ($pageid == 0)  { 
				$status = 0;
			} else {
				$status = 1;
			}
		} 
		else {
			$status = 0;       
		}

		return $status;
	}

}
