<?php

/**
 * Manage Product Overlogo Decorations - 
 *
 * PHP version 7.2
 *
 * @category  Product_Overlogo
 * @package   Overlogo_Settings
 * @author    Sanjeeb Kumar Dakhinaray <steve@imprintnext.com>
 * @copyright 2020-2021 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */

namespace App\Modules\OverLogo\Controllers;

use App\Modules\OverLogo\Models\ProductOverlogoSetting;
use App\Modules\OverLogo\Models\ProductOverlogoSide;
use App\Modules\OverLogo\Models\ProductOverlogoDecorationSetting;


class RenderImageController extends ProductsOverLogoController
{
    public $db;
    public $productInfo;
    public $logoPath;
    public $logoImagePath;
    public $productImagePath;
    public $currentImage = array();

    function __construct($productInfo)
    {

        $uploadLogoDir = ASSETS_PATH_W . CONVERT_FOLDER;
        $extractPhysicalPath = explode($_SERVER['SERVER_NAME'], $_GET['productImage']);
        // $this->productImagePath = $_SERVER['DOCUMENT_ROOT'] . $extractPhysicalPath[1];
        if (STORE_NAME != 'Woocommerce') {
            $this->productImagePath = "https:" . $_GET['productImage'];
        } else {
            $this->productImagePath = $_SERVER['DOCUMENT_ROOT'] . $extractPhysicalPath[1];
        }
        list($this->currentImage['width'], $this->currentImage['height']) = getimagesize($this->productImagePath);
        $this->logoImagePath =  $uploadLogoDir;
        $this->productInfo = $productInfo;
        $this->checkSessionImage();
    }
    /**
     * Get: Image
     * @author steve@imprintnext.com
     * @date   7 Sept 2021
     * @return 
     */
    private function checkSessionImage()
    {
        if (isset($_SESSION['sess_id']) && $_COOKIE['sess_id'] == $_GET['session']) {
            $this->logoPath = $_SESSION['logo_path'];
            $this->logoHeight = $_SESSION['logo_height'];
            $this->logoWidth = $_SESSION['logo_width'];
        } else {
            $this->logoPath = $this->logoImagePath . $_GET['logoUrl'];
            list($this->logoWidth, $this->logoHeight) = getimagesize($this->logoPath);
            $_SESSION['logo_path'] = $this->logoPath;
            $_SESSION['logo_height'] = $this->logoHeight;
            $_SESSION['logo_width'] = $this->logoWidth;
        }
        $this->renderImage();
    }
    /**
     * Get: Imageimage information
     * @author steve@imprintnext.com
     * @date   7 Sept 2021
     * @return Image ration for ovelogo
     */
    private function getImageRatio($logoInfo)
    {


        $productImageRatioHeight = ($this->currentImage['height'] / 600);
        $productImageRatioWidth = ($this->currentImage['width'] / 600);

        $logoInfo['scale'] = min($logoInfo['raw_width'] / $this->logoWidth, $logoInfo['raw_height'] / $this->logoHeight);
        $logoInfo['top'] = $logoInfo['top'] * $productImageRatioHeight; //Scaling top & left position        
        $logoInfo['left'] = $logoInfo['left'] * $productImageRatioWidth; //Scaling top & left position 
        // $logoInfo['width'] = $logoInfo['raw_height'] * $productImageRatioWidth; //Scaling image height & width
        $logoInfo['width'] = $logoInfo['raw_width'] * $productImageRatioWidth; //Scaling image height & width
        $logoInfo['height'] = $logoInfo['raw_height'] * $productImageRatioHeight; //Scaling image height & width
        // $logoInfo['height'] = $logoInfo['height'] * $productImageRatioHeight; //Scaling image height & width
        $logoInfo['logo_height'] = ($this->logoHeight * $logoInfo['scale']) * $productImageRatioHeight;
        $logoInfo['logo_width'] = ($this->logoWidth * $logoInfo['scale']) * $productImageRatioWidth;
        $logoInfo['left'] = $logoInfo['left'] + (($logoInfo['width'] - $logoInfo['logo_width']) / 2);
        $logoInfo['top'] = $logoInfo['top'] + (($logoInfo['height'] - $logoInfo['logo_height']) / 2);
        if (isset($logoInfo['angle']) && $logoInfo['angle'] > 10 && $logoInfo['angle'] <= 90) {
            $logoInfo['left'] = ($logoInfo['left'] - (($logoInfo['width'] - $logoInfo['logo_width']) / 2)) - $logoInfo['angle'];
            $logoInfo['top'] = $logoInfo['top'] + ($logoInfo['angle'] / 2);
        }
        if ($logoInfo['type'] == 'skew') {
            $logoInfo['path'] =  explode(' ', $logoInfo['raw_path']);
            for ($i = 0; $i < count($logoInfo['path']); $i += 2) {
                $logoInfo['path'][$i] = $logoInfo['path'][$i] * $productImageRatioWidth;
            }
            for ($i = 1; $i < count($logoInfo['path']); $i += 2) {
                $logoInfo['path'][$i] = $logoInfo['path'][$i] * $productImageRatioHeight;
            }
        }
        return $logoInfo;
    }
    /**
     * Get: 
     * @author steve@imprintnext.com
     * @date   7 Sept 2021
     * @return Render logo and product image & generate Product image with logo.
     */
    public function renderImage()
    {
        $isDboundary = false;
        $command = "convert {$this->productImagePath} ";
        $listCommands = array();
        $logoPositions = json_decode($this->productInfo['logo_position'], true);
        foreach ($logoPositions as $logoPos) {
            $logoPos = $this->getImageRatio($logoPos);
            $currentCommand = "  \( {$this->logoPath} ";
            if (isset($logoPos['type']) && $logoPos['type'] == 'skew' && isset($logoPos['path'])) {
                $isDboundary = true;
                $skewArea = $logoPos['path'];
                $currentCommand .= " -virtual-pixel none +distort perspective ";
                $currentCommand .= " \"0,0 {$skewArea[0]},{$skewArea[1]} {$this->logoWidth},0 {$skewArea[2]},{$skewArea[3]} {$this->logoWidth},{$this->logoHeight} {$skewArea[4]},{$skewArea[5]} 0,{$this->logoHeight} {$skewArea[6]},{$skewArea[7]}\" ";
            } else {
                $currentCommand .= " -resize {$logoPos['logo_width']}x{$logoPos['logo_height']} ";
            }
            if (isset($logoPos['angle']) && $logoPos['angle'] != 0) {
                $currentCommand .= " -background none -rotate {$logoPos['angle']} ";
            }
            if (isset($logoPos['surface'])) {
                switch ($logoPos['surface']) {
                    case  'glass':
                        $currentCommand .= " -colorspace gray -channel a -evaluate multiply 0.3 ";
                        break;
                    case 'wood':
                        $currentCommand .= " -colorspace Gray -ordered-dither o2x2 -channel a -evaluate multiply 0.4 ";
                        break;
                    case 'metal':
                        $currentCommand .= " -colorspace Gray -ordered-dither o2x2 -channel a -evaluate multiply 0.4";
                        break;
                }
            }
            if ($logoPos['left'] && $logoPos['top']) {
                $currentCommand .= "-geometry +{$logoPos['left']}+{$logoPos['top']}";
            }
            if ($isDboundary) {
                $currentCommand .= " \) -layers flatten +repage ";
            } else {
                $currentCommand .= " \) -composite ";
            }
            $listCommands[] =  $currentCommand;
        }
        $command .= implode(' ', $listCommands) . '  -background white -flatten jpg:-';
        header("HTTP/1.1 200 OK");
        header("Content-Type: image/jpg");
        ob_end_clean();
        echo shell_exec($command);
        exit;
    }
}
