<?php
/**
 * Product Overlogo Setting
 *
 * PHP version 5.6
 *
 * @category  Product_Overlogo_Setting
 * @package   Products
 * @author    Sanjeeb Kumar Dakhinaray <steve@imprintnext.com>
 * @copyright 2020-2021 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace App\Modules\OverLogo\Models;

/**
 * Product Setting Class
 *
 * @category Product_Overlogo_Setting
 * @package  Products
 * @author   Sanjeeb Kumar Dakhinaray <steve@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class ProductOverlogoSetting extends \Illuminate\Database\Eloquent\Model
{
    protected $primaryKey = 'xe_id';
    protected $guarded = ['xe_id'];
    protected $fillable = [
        'store_id',
        'product_id',
        'is_overlogo'
    ];
    public $timestamps = false;
    protected $modelPath = 'App\Modules\Products\Models';
}
