<?php

/**
 * Product Options
 *
 * PHP version 5.6
 *
 * @category  Product_Variants
 * @package   Products
 * @author    Debasis Rath <dan@imprintnext.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */

namespace App\Modules\Products\Models;

/**
 * ProductOptionRel Class
 *
 * @category Product_Variants
 * @package  Products
 * @author   Debasis Rath <dan@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */

class ProductOptionRel extends \Illuminate\Database\Eloquent\Model
{
    protected $table = 'product_option_rel';
    protected $primaryKey = 'xe_id';
    protected $guarded = ['xe_id'];

    protected $fillable = ['product_id', 'option_id', 'option_values', 'position'];
    protected $casts = [
        'option_values' => 'array', 'values' => 'array'
    ];
    public $timestamps = false;
    protected $modelPath = 'App\Modules\Products\Models';

    /**
     * Create Many-to-One relationship between ProductOptions and ProductOptionRel
     *
     * @author  Debasis Rath <dan@imprintnext.com>
     * @date    16-Nov-2022
     * @return relationship object of product options
     */
    public function option()
    {
        return $this->belongsTo(
            'App\Modules\Products\Models\ProductOptions',
            'option_id',
            'xe_id'
        );
    }

    public function getAllOptions($productId = null)
    {
        $query = $this->join('product_options', 'product_option_rel.option_id', '=', 'product_options.xe_id')->select([
            'product_option_rel.xe_id as id', 'product_option_rel.option_values as values',
            'product_option_rel.position', 'product_option_rel.product_id', 'product_options.name'
        ]);

        if ($productId) {
            $query->where('product_id', '=', $productId);
        }
        return $query;
    }
}