<?php
/**
 * Manage Common routes
 *
 * PHP version 5.6
 *
 * @category  Common_Routes
 * @package   Configuration
 * @author    Tanmaya Patra <tanmayap@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
use App\Components\Controllers\Component as ParentController;
use App\Middlewares\ValidateJWTToken as ValidateJWT;

/**
 * Common Categories Routes List
 */
$app->group(
	'/categories/{slug}', function () use ($app) {
		$app->get('/{id}', ParentController::class . ':getCategories');
		$app->post('', ParentController::class . ':saveCategory');
		$app->get('/print-profiles/{id}', ParentController::class . ':getCategoryByPrintProfile');
		$app->get('/disable/{id}', ParentController::class . ':disableCategory');
		$app->post('/sort', ParentController::class . ':sortCategory');
		$app->post('/default', ParentController::class . ':setDefault');
		$app->post('/reset-default', ParentController::class . ':resetDefault');
		// Update Category
		$app->post('/{id}', ParentController::class . ':updateCategory');
	}
)->add(new ValidateJWT($container));


$app->get('/categories/{slug}', ParentController::class . ':getCategories');

// Get Tag list by slug name
$app->group(
	'/tags/{slug}', function () use ($app) {
		$app->get('', ParentController::class . ':getAssetTags');
	}
);

// Capture Image Routes
$app->group(
	'/capture-images', function () use ($app) {
		$app->post('', ParentController::class . ':saveCaptureImage');
	}
)->add(new ValidateJWT($container));

// Dashboard Routes
$app->get('/dashboard', ParentController::class . ':getDashboardData')->add(new ValidateJWT($container));

// Get Logs output as HTML
$app->group(
	'/logs', function () use ($app) {
		$app->get('/', ParentController::class . ':xeLogs');
	}
);
// Preview Images
$app->get('/preview-images', ParentController::class . ':getCustomPreviewImages');

//For name and number
$app->post('/name-number-sample', ParentController::class . ':createNameNumberCsvSample');
$app->get('/name-number-sample-download', ParentController::class . ':downloadNameNumberCsvSample');
//Production Hub
$app->group(
	'/production', function () use ($app) {
		$app->get('/status', ParentController::class . ':getProductionStatus');
		$app->post('/tags', ParentController::class . ':saveProductionTags');
		$app->get('/tags', ParentController::class . ':getProductionTags');
		$app->post('/settings', ParentController::class . ':saveProductionSetting');
		$app->post('/emailsettings', ParentController::class . ':saveEmailSettings');
		$app->delete('/emailsettings/{id}', ParentController::class . ':deleteCustomerEmailTemplate');
		$app->get('/settings', ParentController::class . ':getProductionSetting');
		$app->get('/modules', ParentController::class . ':getProductionModule');
		$app->get('/email/abbr', ParentController::class . ':getEmailAbbriviation');
	}
)->add(new ValidateJWT($container));

$app->group('/language-traverse', function () use ($app) {
	$app->get('', ParentController::class . ':modifyJson');
})->add(new ValidateJWT($container));

//For active store
$app->post('/store-active', ParentController::class . ':storeActive');
//Only for update package
$app->get('/latest-version', ParentController::class . ':getLatestVersion');
$app->get('/admin-language', ParentController::class . ':getAdminLanguage');

// Save Assets Image Routes
$app->group(
	'/assets-images', function () use ($app) {
		$app->post('', ParentController::class . ':saveAssetImage');
	}
)->add(new ValidateJWT($container));
//For Email Log
$app->get('/email-log', ParentController::class . ':getDataForEmailLog')->add(new ValidateJWT($container));
$app->post('/email-log-clear', ParentController::class . ':clearDataForEmailLog')->add(new ValidateJWT($container));
$app->get('/email-log-download/{id}', ParentController::class . ':createCsvForEmailLog')->add(new ValidateJWT($container));
$app->group(
    '/server', function () use ($app) {        
       $app->get(
        '/getserverspace', ParentController::class . ':getServerSpace'
        );
       $app->get(
        '/deletefile', ParentController::class . ':deleteFile'
        );
 }
)->add(new ValidateJWT($container));
// For mail test
$app->post('/email-test', ParentController::class . ':smtpMailTest')->add(new ValidateJWT($container));
// For Quote 
$app->get('/quote-my-account', ParentController::class . ':enableQuoteForMyAccount');