<?php
/**
 * Asset Type Model
 *
 * PHP version 5.6
 *
 * @category  Asset_Type
 * @package   Assets
 * @author   Sanjeeb Kumar Dakhinaray <steve@imprintnext.com>
 * @copyright 2021-2022 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace App\Components\Models;

/**
 * Product Setting Class
 *
 * @category bigcommerce_cart
 * @package  cart
 * @author   Sanjeeb Kumar Dakhinaray <steve@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class BigcommerceCart extends \Illuminate\Database\Eloquent\Model
{
    protected $table = 'bigcommerce_cart';
    protected $primaryKey = 'xe_id';
    protected $guarded = ['xe_id'];
    protected $fillable = [
        'product_id',
        'variant_id',
        'cart_id',
        'line_item_id',
        'custom_design_id'
    ];
    public $timestamps = false;
}
