<?php
/**
 * Store Model
 *
 * PHP version 5.6
 *
 * @category  Opencart
 * @package   Opencart
 * @author    Mukesh Pradhan <mukeshp@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace ComponentStoreSpace\Models;

/**
 * Opencart Model Class
 *
 * @category Opencart
 * @package  Opencart
 * @author   Mukesh Pradhan <mukeshp@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class Customer
{
    /**
     * Initialize Constructor
     */
    public function __construct($con, $store)
    {
        $this->con = $con;
        $this->store = $store;
    }

    /**
     * date of created 18-08-2020(dd-mm-yy)
     * date of Modified (dd-mm-yy)
     * Get All Countries for opencart 3
     *
     * @return array
     */
    public function getCountries() {
        $countryData = array();
        $sql = "SELECT * FROM " . DB_PREFIX . "country WHERE status = '1' ORDER BY name ASC";
        $params = array();
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        $i = 0;
        while ($row = mysqli_fetch_array($query)) {
            $countryData[$i]['countries_name'] = $row['name'];
            $countryData[$i]['countries_code'] = $row['iso_code_3'];
            $i++;
        }
        return $countryData;
    }

    public function getAllCustomers($filter) {
        $data = (object) $filter;
        $customerData = array();
        $totalCount = 0;
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE status = 1";
        $params = array();
        if (empty($data->fetch) && empty($data->$notification)) {
            if($data->customer_no_order == "true") {
                $sql .= " AND customer_id NOT IN(SELECT customer_id FROM " . DB_PREFIX . "order WHERE order_status_id > 0)";
                $totalCount = $this->customerCount(1);
            } else {
                $sql .= " AND customer_id IN(SELECT customer_id FROM " . DB_PREFIX . "order WHERE order_status_id > 0)";
                $totalCount = $this->customerCount(0);
            }
        } else {
            $totalCount = $this->customerCount(2);
        }
        if (isset($data->search) && $data->search != "") {
            $sql .= " AND firstname like ? OR lastname like ?";
            $datasearchstring = "%" . $data->search . "%";
            $params[0] .= 'ss';
            $params[] = &$datasearchstring;
            $params[] = &$datasearchstring;
        }

        if (isset($data->orderby) && $data->orderby == "post_date") {
            $sql .= " ORDER BY customer_id ";
        } elseif (isset($data->orderby) && $data->orderby == "name") {
            $sql .= " ORDER BY firstname ";
        } else {
            $sql .= " ORDER BY customer_id ";
        }
        if (isset($data->order) && $data->order != "") {
            $sql .= $data->order;
        } else {
            $sql .= 'DESC';
        }
        $limit = '';
        if ($data->page) {
            $start = (int) $data->per_page * ((int) $data->page - 1);
        } else {
            $start = 0;
        }
        if (isset($data->per_page) && !empty($data->per_page)) {
            $limit = ' limit ? , ?';
            $params[0] .= 'ss';
            $params[] = &$start;
            $params[] = &$data->per_page;
        }
        $sql .= $limit;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        $i = 0;
        while ($row = mysqli_fetch_array($query)) {
            $totalOrder = 0;
            $lastOrderId = 0;
            if($data->customer_no_order == "false") {
                $getOrders = $this->getOrdersByCustomer($row['customer_id']);
                $totalOrder = count($getOrders);
                $lastOrderId = $getOrders[0]['order_id'];
            }
            $customerData[$i] = [
                'id' => $row['customer_id'],
                'first_name' => $row['firstname'],
                'last_name' => $row['lastname'],
                'email' => $row['email'],
                'total_orders' => $totalOrder,
                'last_order_id' => $lastOrderId,
                'date_created' => date(
                    'd/M/Y H:i:s', strtotime($row['date_added'])
                ),
            ];
            $i++;
        }
        $finalResult['total_user'] = $totalCount;
        $finalResult['customer_list'] = $customerData;
        return $finalResult;
    }

    public function getOrdersByCustomer($customerId) {
        $orderData = array();
        $sql = "SELECT order_id, customer_id, order_status_id, date_added FROM " . DB_PREFIX . "order WHERE `customer_id` = ? AND `order_status_id` > 0 ORDER BY `order_id` DESC";
        $params = array();
        $params[] = 'i';
        $params[] = &$customerId;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        while ($row = mysqli_fetch_array($query)) {
            $orderData[] = $row;
        }
        return $orderData;
    }

    public function getStatesByCountry($country) {
        $countryId = $this->getCountryIdByCode($country);
        $sql = "SELECT * FROM " . DB_PREFIX . "zone WHERE country_id = ? AND status = '1' ORDER BY name";
        $params = array();
        $params[] = 'i';
        $params[] = &$countryId;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        $i = 0;
        while ($row = mysqli_fetch_array($query)) {
            $stateData[$i]['state_code'] = $row['code'];
            $stateData[$i]['state_name'] = $row['name'];
            $i++;
        }
        return $stateData;
    }

    public function getCountryIdByCode($name) {
        $countryId = 0;
        $sql = "SELECT country_id FROM " . DB_PREFIX . "country WHERE iso_code_3 = ? AND status = '1'";
        $params = array();
        $params[] = 's';
        $params[] = &$name;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        while ($row = mysqli_fetch_array($query)) {
            $countryId = $row['country_id'];
        }
        return $countryId;
    }

    public function getCustomer($customerId) {
        $customerData = array();
        $sql = "SELECT ccu.*, caf.company, caf.website FROM " . DB_PREFIX . "customer ccu LEFT JOIN " . DB_PREFIX . "customer_affiliate caf ON caf.customer_id = ccu.customer_id WHERE ccu.customer_id = ?";
        $params = array();
        $params[] = 'i';
        $params[] = &$customerId;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        while ($row = mysqli_fetch_array($query)) {
            $customerData[] = $row;
        }
        
        return $customerData;
    }

    /**
     * date of created 26-08-2020(dd-mm-yy)
     * date of Modified (dd-mm-yy)
     *
     * @param (Array)get Customer address
     * @return array
     */ 
    public function getShippingAddress($customer_id){
        
        $language_id = $this->getLanguageId();
        $sqlPhone = "SELECT telephone FROM `" . DB_PREFIX . "customer` WHERE language_id = ? AND customer_id = ?";
        $params = array();
        $params[] = 'ii';
        $params[] = &$language_id;
        $params[] = &$customer_id;
        $stmt = $this->con->prepare($sqlPhone);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $queryPhone = $stmt->get_result();
        $row = mysqli_fetch_array($queryPhone);
        $telephone = $row['telephone'];
        
        $address = array();
        $sql = "SELECT *, c.name as country FROM  `" . DB_PREFIX . "address` a LEFT JOIN `" . DB_PREFIX . "country` c ON (c.country_id = a.country_id) LEFT JOIN `" . DB_PREFIX . "zone` z ON (z.zone_id = a.zone_id) WHERE customer_id = ? ";
        $params = array();
        $params[] = 'i';
        $params[] = &$customer_id;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        $i = 0;
        while ($row = mysqli_fetch_array($query)) {
            if($i==0){
              $address['billing']['address_1'] = $row['address_1'];
              $address['billing']['address_2'] = $row['address_2'];
              $address['billing']['country_code'] = $row['iso_code_3'];
              $address['billing']['country'] = $row['country'];
              $address['billing']['state_code'] = $row['code'];
              $address['billing']['state'] = $row['name'];
              $address['billing']['city'] = $row['city'];
              $address['billing']['postcode'] = $row['postcode'];
              $address['billing']['phone'] = $telephone;
            }
            $address['shipping'][$i]['id'] = $row['address_id'];
            $address['shipping'][$i]['address_1'] = $row['address_1'];
            $address['shipping'][$i]['address_2'] = $row['address_2'];
            $address['shipping'][$i]['country_code'] = $row['iso_code_3'];
            $address['shipping'][$i]['country'] = $row['country'];
            $address['shipping'][$i]['state_code'] = $row['code'];
            $address['shipping'][$i]['state'] = $row['name'];
            $address['shipping'][$i]['city'] = $row['city'];
            $address['shipping'][$i]['postcode'] = $row['postcode'];
            $address['shipping'][$i]['phone'] = $telephone;
            $i++;
        }
        return $address;
    }

    public function getCountry($countryId) {
        $countryData = array();
        $sql = "SELECT * FROM " . DB_PREFIX . "country WHERE country_id = ? AND status = '1'";
        $params = array();
        $params[] = 'i';
        $params[] = &$countryId;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        while ($row = mysqli_fetch_array($query)) {
            $countryData[] = $row;
        }
        return $countryData;
    }

    public function getZone($zoneId) {
        $stateData = array();
        $sql = "SELECT * FROM " . DB_PREFIX . "zone WHERE zone_id = ? AND status = '1'";
        $params = array();
        $params[] = 'i';
        $params[] = &$zoneId;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        while ($row = mysqli_fetch_array($query)) {
            $stateData[] = $row;
        }
        return $stateData;
    }

    public function customerCount($isNoOrders=2) {
        $customerData = array();
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE status = 1";
        if ($isNoOrders !== 2) {
            if ($isNoOrders) {
                $sql .= " AND customer_id NOT IN(SELECT customer_id FROM " . DB_PREFIX . "order WHERE order_status_id > 0)";
            } else {
                $sql .= " AND customer_id IN(SELECT customer_id FROM " . DB_PREFIX . "order WHERE order_status_id > 0)";
            }
        }
        $params = array();
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        while ($row = mysqli_fetch_array($query)) {
            $customerData[] = $row;
        }
        return count($customerData);
    }

    /**
     * date of created 05-09-2020(dd-mm-yy)
     * date of Modified (dd-mm-yy)
     * Add shipping Address for opencart 3
     *
     * @param (Array)add Customer address
     * @return array
     */ 
    public function addShippingAddress($address){
        $status = false;
        $countryId = 0;
        $stateId = 0;
        // country Id
        if ($address['country']) {
            $countryId = $this->getCountryIdByCode($address['country']);
            // state Id
            if ($address['state']) {
                $stateId = $this->getZoneIdByCode($countryId, $address['state']);
            }
        }
        $sql = "INSERT INTO " . DB_PREFIX . "address SET customer_id = ?, firstname = ?, lastname = ?, company = ?, address_1 = ?, address_2 = ?, city = ?, postcode = ?, country_id = ?, zone_id = ?, custom_field = ''";
        $params = array();
        $params[] = 'isssssssii';
        $params[] = &$address['user_id'];
        $params[] = &$address['first_name'];
        $params[] = &$address['last_name'];
        $params[] = &$address['company'];
        $params[] = &$address['address_1'];
        $params[] = &$address['address_2'];
        $params[] = &$address['city'];
        $params[] = &$address['post_code'];
        $params[] = &$countryId;
        $params[] = &$stateId;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $res = $stmt->execute();
        $stmt->get_result();
        if ($res) {
            $status = true;
        }

        return $status;
    }

    /**
     * date of created 05-09-2020(dd-mm-yy)
     * date of Modified (dd-mm-yy)
     * Add shipping Address for opencart 3
     *
     * @param (Array)add Customer address
     * @return array
     */ 
    public function updateShippingAddress($id,$address){
        $status = false;
        $countryId = 0;
        $stateId = 0;
        // country Id
        if ($address['country']) {
            $countryId = $this->getCountryIdByCode($address['country']);
            // state Id
            if ($address['state']) {
                $stateId = $this->getZoneIdByCode($countryId, $address['state']);
            }
        }
        $sql = "UPDATE " . DB_PREFIX . "address SET address_1 = ? , address_2 = ? , city = ? , postcode = ? , country_id = ? , zone_id = ? WHERE customer_id = ? AND address_id = ?";
        $params = array();
        $params[] = 'ssssiiii';
        $params[] = &$address['address_1'];
        $params[] = &$address['address_2'];
        $params[] = &$address['city'];
        $params[] = &$address['post_code'];
        $params[] = &$countryId;
        $params[] = &$stateId;
        $params[] = &$address['user_id'];
        $params[] = &$id;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $res = $stmt->execute();
        $stmt->get_result();
        if ($res) {
            $status = true;
        }

        return $status;
    }

    public function getZoneIdByCode($countryId, $code) {
        $zoneId = 0;
        $sql = "SELECT * FROM " . DB_PREFIX . "zone WHERE country_id = ? AND code = ? AND status = '1'";
        $params = array();
        $params[] = 'is';
        $params[] = &$countryId;
        $params[] = &$code;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        while ($row = mysqli_fetch_array($query)) {
            $zoneId = $row['zone_id'];
        }
        return $zoneId;
    }

    public function deleteStoreCustomer($ids) {
        $status = false;
        if (!empty($ids)) {
            foreach ($ids as $cusId) {
                $sql = "DELETE FROM " . DB_PREFIX . "customer WHERE customer_id = ?";
                $params = array();
                $params[] = 'i';
                $params[] = &$cusId;
                $stmt = $this->con->prepare($sql);
                call_user_func_array([$stmt, 'bind_param'], $params);
                $stmt->execute();
                $stmt->get_result();

                $sql = "DELETE FROM " . DB_PREFIX . "customer_affiliate WHERE customer_id = ?";
                $params = array();
                $params[] = 'i';
                $params[] = &$cusId;
                $stmt = $this->con->prepare($sql);
                call_user_func_array([$stmt, 'bind_param'], $params);
                $stmt->execute();
                $stmt->get_result();

                $sql = "DELETE FROM " . DB_PREFIX . "customer_approval WHERE customer_id = ?";
                $params = array();
                $params[] = 'i';
                $params[] = &$cusId;
                $stmt = $this->con->prepare($sql);
                call_user_func_array([$stmt, 'bind_param'], $params);
                $stmt->execute();
                $stmt->get_result();

                $sql = "DELETE FROM " . DB_PREFIX . "customer_affiliate WHERE customer_id = ?";
                $params = array();
                $params[] = 'i';
                $params[] = &$cusId;
                $stmt = $this->con->prepare($sql);
                call_user_func_array([$stmt, 'bind_param'], $params);
                $stmt->execute();
                $stmt->get_result();

                $sql = "DELETE FROM " . DB_PREFIX . "customer_reward WHERE customer_id = ?";
                $params = array();
                $params[] = 'i';
                $params[] = &$cusId;
                $stmt = $this->con->prepare($sql);
                call_user_func_array([$stmt, 'bind_param'], $params);
                $stmt->execute();
                $stmt->get_result();

                $sql = "DELETE FROM " . DB_PREFIX . "customer_transaction WHERE customer_id = ?";
                $params = array();
                $params[] = 'i';
                $params[] = &$cusId;
                $stmt = $this->con->prepare($sql);
                call_user_func_array([$stmt, 'bind_param'], $params);
                $stmt->execute();
                $stmt->get_result();

                $sqlIp = "DELETE FROM " . DB_PREFIX . "customer_ip WHERE customer_id = ?";
                $params = array();
                $params[] = 'i';
                $params[] = &$cusId;
                $stmtIp = $this->con->prepare($sqlIp);
                call_user_func_array([$stmtIp, 'bind_param'], $params);
                $stmtIp->execute();
                $stmtIp->get_result();

                $sqlAddr = "DELETE FROM " . DB_PREFIX . "address WHERE customer_id = ?";
                $params = array();
                $params[] = 'i';
                $params[] = &$cusId;
                $stmtAddr = $this->con->prepare($sqlAddr);
                call_user_func_array([$stmtAddr, 'bind_param'], $params);
                $stmtAddr->execute();
                $stmtAddr->get_result();
            }
            $status = true;
        }

        return $status;
    }

    public function createCustomer($data){
        $response = [];
        $countryId = 0;
        $stateId = 0;
        $sCountryId = 0;
        $sStateId = 0;
        $salt = $this->token(9);
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE LOWER(email) = ?";
        $user_email = $data['user_email'];
        $params = array();
        $params[] = 's';
        $params[] = &$user_email;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        $row = mysqli_fetch_array($query);

        if ($row['total']) {
            $response = array('status' => '0', 'message' => 'Email id already exists. Please try another one');
        } else {
            if ($data['billing_country_code']) {
                $countryId = $this->getCountryIdByCode($data['billing_country_code']);
                if ($data['billing_state_code']) {
                    $stateId = $this->getZoneIdByCode($countryId, $data['billing_state_code']);
                }
            }   

            $languageId = $this->getLanguageId();
            $sql = "INSERT INTO " . DB_PREFIX . "customer SET customer_group_id = ?, language_id = ?, firstname = ?, lastname = ?, email = ?, telephone = ?, fax = ?, custom_field = ?, newsletter = ?, salt = ?, password = ?, ip = ?, status = ?, safe = ?, token = ?,  code = ?, date_added = NOW()";
            $params = array();
            $oneValue = '1';
            $zeroValue = '0';
            $customField = json_encode(array());
            $emptyData = '';
            $password = sha1($salt . sha1($salt . sha1($data['user_password'])));
            $params[] = 'sissssssssssssss';
            $params[] = &$oneValue;
            $params[] = &$languageId;
            $params[] = &$data['first_name'];
            $params[] = &$data['last_name'];
            $params[] = &$data['user_email'];
            $params[] = &$data['billing_phone'];
            $params[] = &$emptyData;
            $params[] = &$customField;
            $params[] = &$zeroValue;
            $params[] = &$salt;
            $params[] = &$password;
            $params[] = &$emptyData;
            $params[] = &$oneValue;
            $params[] = &$zeroValue;
            $params[] = &$emptyData;
            $params[] = &$emptyData;
            $stmt = $this->con->prepare($sql);
            call_user_func_array([$stmt, 'bind_param'], $params);
            $res = $stmt->execute();
            $stmt->get_result();
            if ($res) {
                $customerId = mysqli_insert_id($this->con);
                $sqlAddr = "INSERT INTO " . DB_PREFIX . "address SET customer_id = ?, firstname = ?, lastname = ?, company = ?, address_1 = ?, address_2 = ?, city = ?, postcode = ?, country_id = ?, zone_id = ?, custom_field = ?";
                $customField = json_encode(array());
                $params = array();
                $params[] = 'issssssssss';
                $params[] = &$customerId;
                $params[] = &$data['first_name'];
                $params[] = &$data['last_name'];
                $params[] = &$data['company_name'];
                $params[] = &$data['billing_address_1'];
                $params[] = &$data['billing_address_2'];
                $params[] = &$data['billing_city'];
                $params[] = &$data['billing_postcode'];
                $params[] = &$countryId;
                $params[] = &$stateId;
                $params[] = &$customField;
                $stmtAddr = $this->con->prepare($sqlAddr);
                call_user_func_array([$stmtAddr, 'bind_param'], $params);
                $resAddr = $stmtAddr->execute();
                $stmtAddr->get_result();
                if ($resAddr) {
                    $addressId = mysqli_insert_id($this->con);
                    $sqlCus = "UPDATE " . DB_PREFIX . "customer SET address_id = ? WHERE customer_id = ?";
                    $params = array();
                    $params[] = 'ii';
                    $params[] = &$addressId;
                    $params[] = &$customerId;
                    $stmt = $this->con->prepare($sqlCus);
                    call_user_func_array([$stmt, 'bind_param'], $params);
                    $stmt->execute();
                    $stmt->get_result();
                }

            }



            if ($data['shipping_country_code']) {
                $sCountryId = $this->getCountryIdByCode($data['shipping_country_code']);
                if ($data['shipping_state_code']) {
                    $sStateId = $this->getZoneIdByCode($countryId, $data['shipping_state_code']);
                }
            }

            // If billing is not same as shipping address then insert.
            if (!(($data['billing_address_1'] == $data['shipping_address_1']) && ($data['billing_address_2'] == $data['shipping_address_2']) && ($data['billing_city'] == $data['shipping_city']) && ($data['billing_postcode'] == $data['shipping_postcode']) && ($countryId == $sCountryId) && ($stateId == $sStateId))) {

                $sqlAddr = "INSERT INTO " . DB_PREFIX . "address SET customer_id = ?, firstname = ?, lastname = ?, company = ?, address_1 = ?, address_2 = ?, city = ?, postcode = ?, country_id = ?, zone_id = ?, custom_field = ?";
                $params = array();
                $customField = json_encode(array());
                $password = sha1($salt . sha1($salt . sha1($data['user_password'])));
                $params[] = 'issssssssss';
                $params[] = &$customerId;
                $params[] = &$data['first_name'];
                $params[] = &$data['last_name'];
                $params[] = &$data['company_name'];
                $params[] = &$data['shipping_address_1'];
                $params[] = &$data['shipping_address_2'];
                $params[] = &$data['shipping_city'];
                $params[] = &$data['shipping_postcode'];
                $params[] = &$sCountryId;
                $params[] = &$sStateId;
                $params[] = &$customField;
                $stmt = $this->con->prepare($sqlAddr);
                call_user_func_array([$stmt, 'bind_param'], $params);
                $resAddr = $stmt->execute();
                $stmt->get_result();
            }
            // End
            if (isset($data['company_name']) && isset($data['company_url'])) {
                $sqlAffiliate = "INSERT INTO " . DB_PREFIX . "customer_affiliate SET customer_id = ?, company = ?, website = ?, tracking = ?, tax = ?, payment = ?, cheque = ?, paypal = ?, bank_name = ?, bank_branch_number = ?, bank_swift_code = ?, bank_account_name = ?, bank_account_number = ?, custom_field = ?, status = ?, date_added = NOW()";
                $oneValue = '1';
                $zeroValue = '0';
                $emptyData = '';
                $params = array();
                $customField = json_encode(array());
                $password = sha1($salt . sha1($salt . sha1($data['user_password'])));
                $params[] = 'issssssssssssss';
                $params[] = &$customerId;
                $params[] = &$data['company_name'];
                $params[] = &$data['company_url'];
                $params[] = &$emptyData;
                $params[] = &$emptyData;
                $params[] = &$emptyData;
                $params[] = &$emptyData;
                $params[] = &$emptyData;
                $params[] = &$emptyData;
                $params[] = &$emptyData;
                $params[] = &$emptyData;
                $params[] = &$emptyData;
                $params[] = &$emptyData;
                $params[] = &$customField;
                $params[] = &$oneValue;
                $stmt = $this->con->prepare($sqlAffiliate);
                call_user_func_array([$stmt, 'bind_param'], $params);
                $resAddr = $stmt->execute();
                $stmt->get_result();
            }
            if ($customerId) {
                $response = array('status' => 1, 'message' => "Customer Added.");
            }
        }
        return $response;
    }

    public function getLanguageId()
    {
        $language_id = 0;
        $sql = "SELECT language_id FROM `" . DB_PREFIX . "language` WHERE status=?";
        $status_id = 1;
        $params = array();
        $params[] = 'i';
        $params[] = &$status_id;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        $row = mysqli_fetch_array($query);
        if (!empty($row)) {
            $language_id = $row['language_id'];
        }

        return $language_id;
    }

    public function getAddress($addressId) {
        $addressData = array();
        $address_sql = "SELECT * FROM " . DB_PREFIX . "address WHERE address_id = ?";
        $params = array();
        $params[] = 'i';
        $params[] = &$addressId;
        $stmt = $this->con->prepare($address_sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        while ($row = mysqli_fetch_array($query)) {
            $addressData[] = $row;
        }

        return $addressData;
    }

    private function token($length = 32) {
        // Create random token
        $string = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        
        $max = strlen($string) - 1;
        
        $token = '';
        
        for ($i = 0; $i < $length; $i++) {
            $token .= $string[mt_rand(0, $max)];
        }   
        
        return $token;
    }

    public function getAllCustomerIds($filter) {
        $data = (object) $filter;
        $customerData = array();        
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE status = 1";
        $params = array();
        $sql .= " ORDER BY customer_id ";
        $sql .= 'DESC';
        $limit = '';
        if ($data->page) {
            $start = (int) $data->per_page * ((int) $data->page - 1);
        } else {
            $start = 0;
        }
        if (isset($data->per_page) && !empty($data->per_page)) {
            $limit = ' limit ? , ?';
            $params[0] .= 'ss';
            $params[] = &$start;
            $params[] = &$data->per_page;
        }
        $sql .= $limit;
        $stmt = $this->con->prepare($sql);
        call_user_func_array([$stmt, 'bind_param'], $params);
        $stmt->execute();
        $query = $stmt->get_result();
        $i = 0;
        while ($row = mysqli_fetch_array($query)) {
            $customerData[$i]['id'] = $row['customer_id'];
            $i++;
        }
        return $customerData;
    }
}