<?php

/**
 * This Routes holds all the individual route for the User Images
 *
 * PHP version 5.6
 *
 * @category  BarCode
 * @package   BarCode
 * @author    Soumya <soumyas@riaxe.com>
 * @copyright 2022-2023 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */

use App\Middlewares\ValidateJWTToken as ValidateJWT;
use App\Modules\BarCode\Controllers\BarCodeController;
// Instantiate the Container
$container = $app->getContainer();
$app->group(
	'/bar-code', function () use ($app) {
		$app->get('/setting', BarCodeController::class . ':getBarCodeSetting');
		$app->post('/setting', BarCodeController::class . ':saveBarCodeSetting');
        $app->get('/generator', BarCodeController::class . ':barcodeGenerator');
        $app->post('/print', BarCodeController::class . ':printBarCode');
        $app->get('/module', BarCodeController::class . ':getBarcodeModuleData');
		$app->get('/number', BarCodeController::class . ':getBarCodeNumberDetails');
		$app->post('/order-status', BarCodeController::class . ':importOrderStatus');
	}
)->add(new ValidateJWT($container));