<?php
/**This Model used for Configurator Pattern & Category relationship
 * Manage Configurator Pattern
 *
 * PHP version 5.6
 *
 * @category  ConfiguratorPattern
 * @package   Assets
 * @author    Dibya Jyoti <divya@imprintnext.com>
 * @copyright 2024-2025 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */

 namespace App\Modules\ConfiguratorPatterns\Models;

 /**
 * Shape Category Relation
 *
 * @category Configurator_Pattern_Category_Relation
 * @package  Assets
 * @author   Dibya Jyoti <divya@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class ConfiguratorPatternCategoryRelationship extends \Illuminate\Database\Eloquent\Model
{
    protected $primaryKey = 'xe_id';
    public $timestamps = false;
    protected $table = 'config_pattern_category_rel';
    protected $fillable = ['config_pattern_id', 'category_id'];

    /**
     * Create a relationship of configurator pattern with configurator pattern Category Relation Model
     *
     * @author divya@imprintnext.com
     * @date  21st April 2024
     * @return relationship object of category
     */
    public function category()
    {
        return $this->hasOne(
            'App\Modules\ConfiguratorPatterns\Models\ConfiguratorPatternCategory', 'xe_id', 'category_id'
        )->select(
            'xe_id', 'name', 'parent_id', 'is_disable'
        );
    }
}