<?php
/**
 * Manage Print Profile
 *
 * PHP version 5.6
 *
 * @category  Product_Overlogo_Decoration_Setting
 * @package   Product
 * @author    Sanjeeb Kumar Dakhinaray <steve@imprintnext.com>
 * @copyright 2020-2021 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace App\Modules\OverLogo\Models;
/**
 * Product Overlogo Decoration Setting Controller
 *
 * @category Product_Decoration_Setting
 * @package  Product
 * @author   Sanjeeb Kumar Dakhinaray <steve@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class ProductOverlogoDecorationSetting extends \Illuminate\Database\Eloquent\Model
{
    protected $primaryKey = 'xe_id';
    protected $guarded = ['xe_id'];
    protected $fillable = [
        'product_setting_id',
        'product_side_id',
        'name',
        'surface',
        'path',
        'logo_position',
        'height',
        'width',
        'print_area_id',
       ];
    public $timestamps = false;
    protected $modelPath = 'App\Modules\Products\Models';

}
