<?php
/**
 * Routes
 *
 * PHP version 5.6
 *
 * @category  Routes
 * @package   SLIM_Routes
 * @author    Tanmaya Patra <tanmayap@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin ProductsController
 */
use App\Middlewares\ValidateJWTToken as ValidateJWT;
use App\Modules\OverLogo\Controllers\ProductsOverLogoController as OverLogo;

$container = $app->getContainer();

/**
 * Measurement Units Routes list
 */
/**
 * Product Overlogo Settings Data Save
 */
$app->group(
    '/overlogo', function () use ($app, $container) {
        $app->get(
            '/getlogoimage/{browser_id}', OverLogo::class . ':getLogoImage'
        );
       $app->get(
            '/processlogo', OverLogo::class . ':processLogo'
        );
        $app->get(
            '/{product_id}', OverLogo::class . ':getProductOverlogo'
        );
        $app->post(
            '', OverLogo::class . ':saveProductOverlogo'
        )->add(new ValidateJWT($container));
       $app->post(
            '/uploadlogoimage', OverLogo::class . ':uploadLogoImage'
        );
        $app->post(
            '/saveuploadedlogo', OverLogo::class . ':saveUploadedLogo'
        );
        $app->get(
            '/generateproductimage/', OverLogo::class . ':generateProductImage'
        );
        $app->get(
            '/removeoverlogosession/', OverLogo::class . ':removeOverlogoSession'
        );
 });
