<?php
/**
 * This Routes holds all the individual route for the Templates
 *
 * PHP version 5.6
 *
 * @category  Template
 * @package   Template
 * @author    Tanmaya Patra <tanmayap@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
use App\Middlewares\ValidateJWTToken as ValidateJWT;
use App\Modules\Templates\Controllers\CategoryController as Category;
use App\Modules\Templates\Controllers\TemplateController as Templates;

// Instantiate the Container
$container = $app->getContainer();

// Templates Route
$app->group(
    '/templates', function () use ($app) {
        
        // Dashboard Count fetching
        $app->get('/most-used', Templates::class . ':mostUsedTemplate');
        // Fetch Single Template
        $app->get('/{id}', Templates::class . ':getSingleTemplate');
        // Save new Records
        $app->post('', Templates::class . ':saveDesigns');
        // Update existing Records
        $app->post('/{id}', Templates::class . ':updateDesigns');
        // Delete existing Record
        $app->delete('/{id}', Templates::class . ':deleteTemplate');
    }
)->add(new ValidateJWT($container));

// Fetch all Templates
$app->get('/templates', Templates::class . ':getTemplates');

// Templates Update Route
$app->group(
    '/designs', function () use ($app) {
        // Update existing Records
        $app->post('/{id}', Templates::class . ':updateTemplates');
    }
)->add(new ValidateJWT($container));

// Categories Routes List
$app->delete('/categories/templates/{id}',  Templates::class . ':deleteCategory')
    ->add(new ValidateJWT($container));


/**
 *Templates import routes
 */
$app->group(
    // Fetch all Templates Request
    '/import-template', function () use ($app) {
        $app->get('', Templates::class . ':importTemplates');
    // Save all Templates which are get by previous import
        $app->post('/save', Templates::class . ':saveImportTemaplates');
    // Fetch all Import Templates
        $app->get('/fetch', Templates::class . ':fetchImportTemaplates');
    // fetch  all category from central server
        $app->get('/central-category', Templates::class . ':fetchCategory');
    }

)->add(new ValidateJWT($container));

// Fetch template details by desing Id
$app->get('/design-state/{id}',  Templates::class . ':getTemplateByDesignId')
    ->add(new ValidateJWT($container));

//Genearte template url
$app->group(
    '/temp-url', function () use ($app) {
        $app->post('', Templates::class . ':saveTemplateURL');
        $app->get('/view-temp/{id}', Templates::class . ':viewTemplate');
    });