<?php

$docAbsPath = ROOTABSPATH . "wp-blog-header.php";
require_once $docAbsPath;

class StoreComponent
{
    public function copyPluginfiles($newImprintStorePath)
    {
        $today = date("d-m-Y");
        $time = date("H-i-s");
        $dateTime = $today . "_" . $time;
        $pluginPath = WP_PLUGIN_DIR.DS.'imprintnext_product_designer';
        //Start rename old folders and files
        if (is_dir($pluginPath)) {
            $oldFilePath = $pluginPath . DS . 'imprintnext_product_designer.php';
            $oldPathRename = $oldFilePath . '_' . $dateTime;
            if (file_exists($oldFilePath)) {
                 rename($oldFilePath, $oldPathRename);
             }
            $oldAssetPath = $pluginPath . DS . 'assets';
            $oldAssetPathRename = $oldAssetPath . '_' . $dateTime;
            if (is_dir($oldAssetPath)) {
                 rename($oldAssetPath, $oldAssetPathRename);
            }
        }
        //Start rename old folders and files before 800 version Imprintnext
        $OlderPluginPath = WP_PLUGIN_DIR.DS.'inkxe_product_designer';
        if (is_dir($OlderPluginPath)) {
            $olderFilePath = $OlderPluginPath . DS . 'inkxe_product_designer.php';
            $olderPathRename = $olderFilePath . '_' . $dateTime;
            if (file_exists($olderFilePath)) {
                 rename($olderFilePath, $olderPathRename);
             }
            $olderAssetPath = $OlderPluginPath . DS . 'assets';
            $olderAssetPathRename = $olderAssetPath . '_' . $dateTime;
            if (is_dir($olderAssetPath)) {
                 rename($olderAssetPath, $olderAssetPathRename);
            }
        }
        $this->recurse_copy($newImprintStorePath . STORE_VERSION . '/plugins', WP_PLUGIN_DIR);
        /*Activate imprintnext product designer plugin*/
        $this->activateAllPlugins();
        if (!@copy($newImprintStorePath . STORE_VERSION . '/frontendlc.php', ROOTABSPATH . 'frontendlc.php')) {
            $errorMsg = '- frontendlc.php file didn\'t copy. \n';
            $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error :' . $errorMsg . "\n");
        }
    }
    
    public function activateAllPlugins() {
        $pluginsStatus = 0;
        $current_plugin = get_option("active_plugins");
        $myplugin = 'imprintnext_product_designer/imprintnext_product_designer.php';
        $plugin = plugin_basename( trim( $myplugin ) );
        if ( !in_array( $plugin, $current_plugin ) ) {
            $current_plugin[] = $plugin;
            sort( $current_plugin );
            do_action( 'activate_plugin', trim( $plugin ) );
            update_option( 'active_plugins', $current_plugin );
            do_action( 'activate_' . trim( $plugin ) );
            do_action( 'activated_plugin', trim( $plugin) );
            $pluginsStatus = 1;
        } 
        return $pluginsStatus;
    }
}
