<?php
$storePath = ROOTABSPATH ."shopify".DS."lib".DS."config.php";
$storePath = str_replace("//", "/", $storePath);
require_once $storePath;
class StoreComponent
{
	public function getShopifyObject(){		
		$configXMLpath = $this->getNewXEpath().XECONFIGXML; // xeconfig xml file
		$dom = new DomDocument();
		$dom->load($configXMLpath) or die("Unable to load xml");
		
	    $apiUSER = $dom->getElementsByTagName('apiuser')->item(0)->nodeValue;
        $apiPASS = $dom->getElementsByTagName('apipass')->item(0)->nodeValue;
        $appSECRET = $dom->getElementsByTagName('secretkey')->item(0)->nodeValue;
        $shop = $dom->getElementsByTagName('shop')->item(0)->nodeValue;
		$apiVersion = $dom->getElementsByTagName('apiversion')->item(0)->nodeValue;

		$domain = $shop . '.myshopify.com';
        return new ShopifyClient($domain, $apiPASS, $apiUSER, $appSECRET, $apiVersion);       
		
	}
/**
	 * Shopify GraphQl API curl function
	 *
	 * @param $method  GraphQl API call method (POST)
	 * @param $payload  Shopify API parameters if any
	 *
	 * @author dan@imprintnext.com
	 * @date   28-10-2022
	 * @return Curlresponse
	 * 
	 * @date 01 July 2024
	 * @modified by pansy@imprintnext.com
	 */
	private function graphQlRequest($query)
	{
		$method = 'POST';
		$configXMLpath = $this->getNewXEpath() . XECONFIGXML; // xeconfig xml file
		$dom = new DomDocument();
		$dom->load($configXMLpath) or die("Unable to load xml");
		$shop = $dom->getElementsByTagName('shop')->item(0)->nodeValue;
		$domain = $shop . '.myshopify.com';
		$apiVersionPath = ROOTABSPATH . "shopify" . DS . "data" . DS . "api_version.json";
		$shopifyVersion = file_get_contents($apiVersionPath);
		$shopify_version = json_decode($shopifyVersion, true);
		$apiVersion = !empty($dom->getElementsByTagName('apiversion')->item(0)->nodeValue) ? $dom->getElementsByTagName('apiversion')->item(0)->nodeValue :  $shopify_version[0]['api_version'];
		$apiPASS = $dom->getElementsByTagName('apipass')->item(0)->nodeValue;
		$apiUrl = "https://{$domain}/" . "admin/api/" . $apiVersion . "/graphql.json";
		$cleanQRY = trim(preg_replace('/\s\s+/', ' ', str_replace("\n", " ", $query)));
		$payload = json_encode(["query" => $cleanQRY]);

		$requestHeaders = [
			'Content-Type: application/json',
			'X-Shopify-Access-Token: ' . $apiPASS
		];
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => $apiUrl,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => $method,
			CURLOPT_POSTFIELDS => $payload,
			CURLOPT_HTTPHEADER => $requestHeaders,
		));
		$response = curl_exec($curl);
		$errno = curl_errno($curl);
		$error = curl_error($curl);
		curl_close($curl);
		if ($errno) {
			create_log('clipart', 'error', [
				'message' => 'Shopify GraphQl Request Error!',
				'extra' => ['errno' => $errno, 'error' => $error]
			]);
			return $error;
		}
		$respData = preg_split("/\r\n\r\n|\n\n|\r\r/", $response, 2);
		if (count($respData) >= 2) {
			return json_decode($respData[1], true);
		} else {
			return json_decode($response, true);
		}
	}

	protected function checkStoreCredential($data)
	{
		extract($data);
		$errorMsg = '';
		try {
			$shopify = new ShopifyClient($shop . '.myshopify.com', $apipass, $apiuser, $secretkey, $apiVersion);
			// $res = $shopify->call('GET', '/admin/products.json');
			$res = $shopify->call('GET', '/admin/oauth/access_scopes.json');
			$access_scopes = array_column($res, 'handle');
			$accessScopepath = ROOTABSPATH . "shopify" . DS . "lib" . DS . "access_scope.json";
			$imprint_scopes = file_get_contents($accessScopepath);
			$imprint_scopes = json_decode($imprint_scopes, true);
			$error = array_diff($imprint_scopes, $access_scopes);
			$error = implode(",", $error);
			if (empty($error)) {
				$status = 1; //'success';
			} else {
				$errorMsg = 'Access Scopes are not set correctly- ' . $error . ' is/are not present in store access scopes';
			}
		} catch (Exception $e) {
			$status = 0;
			$this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error :'  . $e->getMessage() . "\n");
		}
		return array($status, $errorMsg);
	}

	protected function checkStoreCredWrite($dom){
		$status = false;
		if ($dom->getElementsByTagName('shop')->item(0)->nodeValue != "" && $dom->getElementsByTagName('apiuser')->item(0)->nodeValue != "" && $dom->getElementsByTagName('apipass')->item(0)->nodeValue != "" && $dom->getElementsByTagName('secretkey')->item(0)->nodeValue != "") {
			$status = true;
		}
		return $status;
	}

	protected function storeInstallProcess($dom, $baseURL, $basePATH, $dummyData){
        $baseURL =$dom->getElementsByTagName('api_url')->item(0)->nodeValue;
        $aoiUSER= $dom->getElementsByTagName('apiuser')->item(0)->nodeValue;
        $apiPASS= $dom->getElementsByTagName('apipass')->item(0)->nodeValue;
        $appSECRET= $dom->getElementsByTagName('secretkey')->item(0)->nodeValue;
        $shop = $dom->getElementsByTagName('shop')->item(0)->nodeValue;
        $apiVersion = $dom->getElementsByTagName('apiVersion')->item(0)->nodeValue;
        //below 3 should be shifted to store.inc.php after qa testing
        $domain = $shop . '.myshopify.com';
        // $shopURL= 'https://' . $domain;
        // $shopURL . '/admin/oauth/access_token';
        $shopifyPath = str_replace(SETUPFOLDERNAME.DS, '', ROOTABSPATH).SETUPFOLDERNAME.DS."shopify".DS;
        $themeFolder = "theme".DS;

        $shopify = new ShopifyClient($domain, $apiPASS, $aoiUSER, $appSECRET, $apiVersion);
		$this->PutUrlInAssets($shopifyPath.$themeFolder."assets/xe_app.js.liquid", $baseURL);
		$this->PutUrlInAssets($shopifyPath.$themeFolder."snippets/xe_script.liquid", $baseURL);
		$this->PutUrlInAssets($shopifyPath.$themeFolder."templates/page.designer.liquid", $baseURL);
		$this->addAssets2theme($shopify, $shopifyPath.$themeFolder);
		$this->createCollection('show-in-designer', true);
		$this->createCollection('customized', false);
		$this->createCollection('all', false);
		$this->updateSmartCollection();
		if ($dummyData['setup_type'] == "auto") {
			$this->createDummyProduct();
			$this->assignProductToCollection("");
		}else{
			$this->createSampleProducts($dom, $dummyData['products'], $dummyData['print_methods']);
		}
		$this->createWebhooks($shopify, 'orders\/create', 'webhook_order_create', $baseURL);
		$this->createWebhooks($shopify, 'orders\/updated', 'webhook_order_update', $baseURL);
		$this->createWebhooks($shopify, 'products\/update', 'webhook_product_update', $baseURL);
		$this->createWebhooks($shopify, 'collections\/create', 'webhook_collection_create', $baseURL);
		$this->createWebhooks($shopify, 'discounts\/update', 'webhook_discount_update', $baseURL);
		$returnValue = $this->checkProductCreationStatus();
		$returnValue['0'] = 1;
		if($returnValue['0'] == 0){
			$response = array("proceed_next" => false, "message" => "DUMMY_PRODUCT_NOT_CREATED");
	 	}else{
			$response = array("proceed_next" => true, "message" => "DUMMY_PRODUCT_CREATED");
		}
		return $response;
	}

	/**
	 * Internal function to extract numeric value from a set of string
	 */
	public function getNumericData($stringValue)
	{
		$numericValue = preg_replace("/[^0-9]/", '', $stringValue);
		return $numericValue;
	}

	/*
	- Name : Add the smart collection rule
	- it will check if the collection is smart then their value added or not.
	- Return status created or not
	*@modified by pansy@imprintnext.com
	 */
	
	public function updateSmartCollection()
	{
		$collections = [];
		$imprintSmartRules = [
			"condition" => "imprintNext",
			"column" => "VENDOR",
			"relation" => "NOT_EQUALS"
		];
		$query = <<<JSON
        query getCollections {
            collections(first: 250) {
              edges {
                 node {
                        id
                        ruleSet {
                            rules {
                                condition
                                relation
                                column
                            }
                        }
                    }
                }
            }
        }
        JSON;
		$collectionArr = $this->graphQlRequest($query);
		$collections = $collectionArr['data']['collections']['edges'];
		foreach ($collections as $eachCollection) {
			$eachCollection = $eachCollection['node'];
			if (!empty($eachCollection['ruleSet'])) {
				foreach ($eachCollection['ruleSet']['rules'] as $colrule) {
					if (!empty(array_diff($colrule,  $imprintSmartRules))) {
						$eachCollection['ruleSet']['rules'][]  = $imprintSmartRules;
						$rules = array_unique($eachCollection['ruleSet']['rules'], SORT_REGULAR);
						$outputArray = array();
						foreach ($rules as $item) {
							$outputArray[] = "{column: {$item['column']}, relation: {$item['relation']}, condition: \"{$item['condition']}\"}";
						}
						$rules = "[" . implode(",", $outputArray) . "]";

						$query = <<<JSON
								mutation starts {
									collectionUpdate(
										input: {id: "gid://shopify/Collection/{$eachCollection['id']}", ruleSet: {appliedDisjunctively: false, rules: $rules}}
										) {
											collection {
												id
											}
										}
									}
								JSON;
						$updateCollection = $this->graphQlRequest($query);
						$collections = $updateCollection['data']['collectionUpdate']['collection'];
					}
			}
		}
		}

		return $collections;
	}

	/*
	- Name : checkCreateDummyProduct
	- it will check if dummy product has been created or not
	- Return status created or not
	*@modified by pansy@imprintnext.com
	 */

	public function checkCreateDummyProduct($prodHandle, $shopify = [])
	{
		if (empty($shopify)) {
			$shopify = $this->getShopifyObject();
			$prodHandle = "men-tshirt";
		}
	    $dummyProdID = 0;
	    $prodHandle = str_replace(" ", "-", $prodHandle);
		$publicationId = $this->getPublicationId();
		$query = <<<JSON
		query getProductsbyHandle {
			products(first: 250, query: "handle:$prodHandle") {
				edges {
					node {
						id
						publishedOnPublication(publicationId: "$publicationId")
					}
				}
			}
		}
		JSON;
		$productArr = $this->graphQlRequest($query);
		if (!empty($productArr['data']['products']['edges']) && $productArr['data']['products']['edges']['node']['publishedOnPublication'] == true) {
			$products = $productArr['data']['products']['edges']['node'];
			$dummyProdID = $this->getNumericData($products['id']);
		}
	    return $dummyProdID;
	}

	/*
	- Name : checkCreateCollection
	- it will check if custom collection has been created or not
	- Return status created or not
	*@modified by pansy@imprintnext.com
	 */

	private function checkCreateCollection($colName)
	{
	    $thisColID = 0;
		$getCollectionbyHandle = <<<JSON
					query getCollection {
						collectionByHandle(handle: "$colName") {
							id
						}
					}
		JSON;
		$collectionArr = $this->graphQlRequest($getCollectionbyHandle);
		if (!empty($collectionArr['data']['collectionByHandle'])) {
			$thisColID = $this->getNumericData($collectionArr['data']['collectionByHandle']['id']);
	    }
	    return $thisColID;
	}

	/*
	- Name : checkCreateWebhooks
	- it will check if webhooks has been created or not
	- Return status created or not
	 */
	private function checkCreateWebhooks($shopify, $event, $name, $baseURL)
	{
	    $thisHookID = 0;
	    $webhooks = $shopify->call('GET', '/admin/webhooks.json');
	    $webTopic = str_replace('\/', '/', $event);
	    $webURL = $baseURL . "shopify/lib/" . $name . ".php";
	    foreach ($webhooks as $wbhk) {
	        if ($wbhk['topic'] == $webTopic && $wbhk['address'] == $webURL) {
	            $thisHookID = $wbhk['id'];
	        }
	    }
	    return $thisHookID;
	}

	/**
	 * get the Online Store publication ID
	 *
	 * @author pansy@imprintnext.com
	 * @date 26 Jun 2024
	 * @param null
	 * @return Id
	 */
	private function getPublicationId()
	{
		$publicationIDquery = <<<JSON
                            query publicationIDquery {
                                publications(first: 10) {
                                    nodes {
                                    id
                                    name
                                    }
                                }
                            }
                        JSON;
		$publications = $this->graphQlRequest($publicationIDquery);
		$publicationId = '';
		if (!empty($publications['data']['publications']['nodes'])) {
			foreach ($publications['data']['publications']['nodes'] as $eachPublication) {
				if (strtolower($eachPublication['name']) == 'online store') {
					$publicationId = $eachPublication['id'];
				}
			}
		}
		return $publicationId;
	}

	/*
	- Name : createDummyProduct
	- it will create a dummy product in store
	- Return product created message in json
	*@modified by pansy@imprintnext.com
	 */

	private function createDummyProduct()
	{
	    $msg = '';
	    $status = 0;
		$prodCheck = $this->checkCreateDummyProduct("imprintNext-tshirt");
	    if ($prodCheck == 0) {
			$createProductquery = <<<JSON
					mutation CreateProduct {
						productCreate(
							input: {title: "imprintNext Tshirt", descriptionHtml: "<strong>This is a dummy product, created during imprintNext installation.</strong>", vendor: "test", productType: "imprintNext", handle: "imprintNext-tshirt", productOptions: [{name: "color", position: 2, values: {name: "purple"}}, {name: "Size", position: 1, values: {name: "XL"}}]}
							media: {originalSource: "https://cdn.shopify.com/s/files/1/1284/7279/products/s3_purple_front_1024x1024.png", mediaContentType: IMAGE}
						) {
							product {
								id
								variants(first: 10) {
									nodes {
										id
									}
								}
								media(first: 10) {
									nodes {
										id
									}
								}
							}
						}
					}
			JSON;
			$addProductArr = $this->graphQlRequest($createProductquery);
		}
		$publicationId = $this->getPublicationId();
		if (!empty($addProductArr['data']['productCreate'])) {
			$publishQuery = <<<JSON
								mutation starts {
									publishablePublish(
										id: "{$addProductArr['data']['productCreate']['product']['id']}"
										input: {publicationId: "$publicationId"}
									) {
										userErrors {
										message
										}
									}
								}
							JSON;
			$this->graphQlRequest($publishQuery);
			$variantId = $addProductArr['data']['productCreate']['product']['variants']['nodes'][0]['id'];
			$mediaId = $addProductArr['data']['productCreate']['product']['media']['nodes'][0]['id'];
			$variantUpdatequery = <<<JSON
						mutation variantUpadte {
							productVariantUpdate(
								input: {id: "$variantId", inventoryItem: {sku: "imprintNext", measurement: {weight: {value: 200, unit: GRAMS}}}, price: "20.00", inventoryPolicy: DENY, mediaId: "$mediaId", taxable: false}
							) {
								productVariant {
								id
								}
							}
						}
				JSON;
			$variantUpadte = $this->graphQlRequest($variantUpdatequery);

			if (!empty($variantUpadte['data']['productVariantUpdate'])) {
	            $msg = "Dummy Product added.";
				return array($status, $msg);
	        }
	    }
	}

	/*
	- Name : createCollection
	- it will create a collection in store and assign the dummy product to it
	- Return collection details in json

	- @date 02 July 2024
	- @modified by divya@imprintnext.com
	 */
	private function createCollection($name, $isCustom)
	{
	    $msg = '';
	    $status = 0;
	    $colID = $this->checkCreateCollection($name);
	    if ($colID == 0) {
	        $colHndlName = ($name == "Show in Designer" ? "show-in-designer" : $name);
	        if ($isCustom) {
				$collectionArray = <<<JSON
							mutation collectionQuery {
							collectionCreate(input: {descriptionHtml: "<strong>The products under this collection are allowed to be shown in designer tool</strong>", title: "{$name}", handle: "{$colHndlName}"}) {
								collection {
								id
								}
							}
						}
					JSON;
	        } else {
	            if ($name == 'customized') {
					$collectionArray = <<<JSON
					       mutation collectionQuery {
								collectionCreate(
									input: {descriptionHtml: "<strong>All products created to add customized price are included in this collection. This will remain hidden and should not be deleted. Product under this collection will be deleted time to time and will not be allowed for 'Add to cart' or 'customize'</strong>", title: "{$name}", handle: "{$colHndlName}", ruleSet: {appliedDisjunctively: false, rules: [{column: TAG, relation: EQUALS, condition: "customized"},
									{column: VENDOR, relation: NOT_EQUALS, condition: "imprintNext"}]}}
								) {
									collection {
									id
									}
								}
							}
					JSON;
	            } elseif ($name == 'all') {
					$collectionArray = <<<JSON
					       mutation collectionQuery {
								collectionCreate(
									input: {descriptionHtml: "<strong>This collection removes user created duplicate products from product catalog.</strong>", title: "{$name}", handle: "{$colHndlName}", ruleSet: {appliedDisjunctively: false, rules: {column: VENDOR, relation: NOT_EQUALS, condition: "imprintNext"}}}
								) {
									collection {
									id
									}
								}
							}
					JSON;
	            }
	        }
	        try {
				$collectionCreateData = $this->graphQlRequest($collectionArray);
				if ($name != 'customized') {
					//publishing the collection globally, i.e. adding into sales channel
					$collectionId = $collectionCreateData['data']['collectionCreate']['collection']['id'];
					if (!empty($collectionId)) {
						$publishQuery = <<<JSON
									mutation starts {
										publishablePublish(
											id: "{$collectionId}"
											input: {publicationId: "{$this->getPublicationId()}"}
										) {
											userErrors {
											message
										}
								}
							}
						JSON;
						$this->graphQlRequest($publishQuery);
					}
	            }
	        } catch (Exception $e) {
	            $msg = 'collection creation error: ' . $e->getMessage();
	            $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error : ' . $msg . ' : ' . $e->getMessage() . "\n");
	        }

	        if (is_array($collectionCreateData)) {
	            $msg = $name . " collection has been created.";
	            $status = 1;
	            return array($status,$msg);
	        }
	    }
	}

	/*
	- Name : assignProductToCollection
	- it will assign the dummy product to the colletion
	- Return status assigned or not

	- @date 02 July 2024
	- @modified by divya@imprintnext.com
	 */
	private function assignProductToCollection($dummyProdID)
	{
	    $msg = '';
	    $status = 0;
	    if ($dummyProdID == "") {
	    	$dummyProdID = $this->checkCreateDummyProduct( "imprintNext-tshirt");
	    }
	    $designColID = $this->checkCreateCollection("show-in-designer");
	    if ($dummyProdID > 0 && $designColID > 0) {
			$checkCollectionQuery = <<<JSON
			  query productInCollection {
			  collection(id: "gid://shopify/Collection/$designColID") {
				hasProduct(id: "gid://shopify/Product/$dummyProdID")
			   }
			 }
			JSON;
			$checkCollection = $this->graphQlRequest($checkCollectionQuery);
	        if (!$checkCollection['data']['collection']['hasProduct']) {
				$addProductToCollectionQuery = <<<JSON
				 mutation productAssignToCollection {
				  collectionAddProducts(id: "gid://shopify/Collection/$designColID", productIds: "gid://shopify/Product/$dummyProdID") {
					userErrors {
					message
					}
				  }
				 }
				JSON;
				$addProductInCol = $this->graphQlRequest($addProductToCollectionQuery);
	        }
	    }
	    if (empty($addProductInCol['data']['collectionAddProducts']['userErrors'])) {
	        $status = 1;
	        $msg = 'Dummy Product has been added to Show in Designer colection';
	    } 
	    return array($status,$msg);

	}

	/*
	- Name : createWebhooks
	- it will create webhooks to store
	- Return status created or not
	 */
	private function createWebhooks($shopify, $event, $name, $baseURL)
	{
	    $msg = '';
	    $status = 0;
	    $webhookID = $this->checkCreateWebhooks($shopify, $event, $name, $baseURL);
	    if ($webhookID == 0) {
	        $webhookPATH = $baseURL . "shopify/lib/" . $name . ".php";
	        $webhook_array = array(
	            "webhook" => array(
	                "topic" => $event,
	                "address" => $webhookPATH,
	                "format" => "json",
	            ),
	        );
	        error_reporting(0);
	        try {
	            $addWebhook = $shopify->call('POST', '/admin/webhooks.json', $webhook_array);
	            if (!empty($addWebhook) && isset($addWebhook['id'])) {
	                $status = 1;
	                $msg = $name.' webhook has been created';
	                return array($status,$msg);
	            }
	        } catch (Exception $e) {
	            $msg = 'Webhook error: ' . $e->getMessage();
	            $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error : ' . $msg . ' : ' . $e->getMessage() . "\n");
	        }
	    } else {
	        $msg = $event .'Webhook was already created for this store.';
	        $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error : ' . $msg . "\n");
	    }
	}

	/*
	- Name : checkProductCreationStatus
	- it will check if Step-3 has been completed or not
	- Return status success or error
	 */
	private function checkProductCreationStatus()
	{
	    $productData =[
			"message" => " - Dummy product is not yet created. \n",
			"status" => 0
		];
	    $dummyProdChk = $this->checkCreateDummyProduct("men-tshirt");
		if ($dummyProdChk > 0) {
			$productData =[
				"message" => "DUMMY PRODUCT CREATED",
				"status" => 1
			];
	    }
	    return $productData;
	}

	private function PutUrlInAssets($file, $baseURL)
	{
	    $path = DS.$file;
	    if (file_exists($path)) {
	        @chmod($path, 0777);
	        $settingStr = @file_get_contents($path);
	        $settingStr = str_replace("XEPATH", $baseURL, $settingStr);
	        @file_put_contents($path, $settingStr);
	    }
	}
	/**
	 *
	 * @param shopify object
	 * @return json
	 */
	private function addAssets2theme($shopify, $themeFolder)
	{
	    $themes = $shopify->call('GET', '/admin/themes.json');
	    $curThemeID = 0;
	    foreach ($themes as $thm) {
	        if ($thm['role'] == "main") {
	            $curThemeID = $thm['id'];
	        }
	    }
	    $this->uploadTheme($shopify, 'assets/', $curThemeID, $themeFolder);
	    $this->uploadTheme($shopify, 'templates/', $curThemeID, $themeFolder);
	    $this->uploadTheme($shopify, 'snippets/', $curThemeID, $themeFolder);
			$this->addDesignerPage($shopify);
	}

	private function addDesignerPage($shopify)
	{
		$page_array = array(
			"page" => array(
				"title" => "designer studio",
				"handle" => "designer-studio",
				"template_suffix" => "designer",
				"body_html" => "<p>Online Design Studio with  <strong>Artificial intelligence & Augmented reality</strong>.</p>"
			),
		);
		$getAllPage = $shopify->call('GET', '/admin/pages.json');
		$getAllPage = array_column($getAllPage, 'handle');
		if (!in_array("designer-studio", $getAllPage)) {
			$shopify->call('POST', '/admin/pages.json', $page_array);
		}
	}

	private function uploadTheme($shopify, $directory, $curThemeID, $themeFolder)
	{
	    $fileExists = false;
	    $base = DS.$themeFolder;
	    $baseURL = $this->getPKGURL()."shopify/theme/";
	    $files = glob($base . $directory . "*.*");
	    foreach ($files as $file) {
	        $fileName = substr(strrchr($file, "/"), 1);
	        try {
	            $check = $shopify->call('GET', '/admin/themes/' . $curThemeID . '/assets.json?asset[key]=' . $directory . $fileName);
	            if ($check) {
	                $shopify->call('DELETE', '/admin/themes/' . $curThemeID . '/assets.json?asset[key]=' . $directory . $fileName);
	            }
	        } catch (Exception $e) {
	            $fileExists = true;
	            $file_array = array(
	                "asset" => array(
	                    "key" => $directory . $fileName,
	                    "src" => $baseURL . $directory . $fileName,
	                ),
	            );
	            $shopify->call('PUT', '/admin/themes/' . $curThemeID . '/assets.json', $file_array);
	        }
	        if (!$fileExists) {
	            $file_array = array(
	                "asset" => array(
	                    "key" => $directory . $fileName,
	                    "src" => $baseURL . $directory . $fileName,
	                ),
	            );
	            $shopify->call('PUT', '/admin/themes/' . $curThemeID . '/assets.json', $file_array);
	        }
	    }
	}

	protected function getPKGURL(){
		$baseURLData = $this->getBaseUrl();
		$baseURL = $baseURLData[1];
		str_replace(SETUPFOLDERNAME.DS, '', ROOTABSPATH);
		return $baseURL.INSTALLFOLDER. DS;
	}

	protected function getDummyProductURL($dom){
		$shop = $dom->getElementsByTagName('shop')->item(0)->nodeValue;
        $domain = $shop . '.myshopify.com';
        $shopURL= 'https://' . $domain;
        return $shopURL."/collections/all";
	}

	private function createSampleProducts($dom, $prodArr, $printMethods){
		foreach ($prodArr as $productID) {
			$productData = file_get_contents(DUMMYDATADIR."product_".$productID.".json");
			$productData = json_decode($productData, true);
			$this->createDemoProduct($dom, $productData, $printMethods);
		}
	}

	private function createDemoProduct($dom, $productData, $printMethods){
		$productTitle = $productData['data']['product_name'];
		$thisProductID = $this->checkCreateDummyProduct($productTitle);
		if ($thisProductID == 0) {
			$prodHndlName = str_replace(' ', '-', $productTitle);
			$optionsArr = array();
			$optionNo = 1;
			$hasSize = false;
			$hasColor = false;
			if (array_key_exists('size', $productData['data'])) {
				$optionsArr[] = array("name" => "size","position" => $optionNo, "values" => array_column($productData['data']['size'], 'name'));
				$optionNo++;
				$hasSize = true;
			}
			if (array_key_exists('color', $productData['data'])) {
				$optionsArr[] = array("name" => "color","position" => $optionNo, "values" => array_column($productData['data']['color'], 'name'));
				$hasColor = true;
			}
			$variantArr = array();
			if ($hasSize && $hasColor) {
				foreach ($productData['data']['size'] as $size) {
					foreach ($productData['data']['color'] as $color) {
						$thisVar = array("option1" => $size['name'], "option2" => $color['name'], "sku" => "imprintNext_demo", "price" => 20.00, "grams" => 200,"taxable" => false, "inventory_policy" => "continue");
						$thisVar['attributes'] = array("size" => $size['name'], "color" => $color['name']);
						$variantArr[] = $thisVar;
					}
				}
			}elseif ($hasSize && !$hasColor) {
				foreach ($productData['data']['size'] as $size) {
					$thisVar = array("option1" => $size['name'], "sku" => "imprintNext_demo", "price" => 20.00, "grams" => 200,"taxable" => false, "inventory_policy" => "continue");
					$thisVar['attributes'] = array("size" => $size['name']);
					$variantArr[] = $thisVar;

				}
			}elseif (!$hasSize && $hasColor) {
				foreach ($productData['data']['color'] as $color) {
					$thisVar = array("option1" => $color['name'], "sku" => "imprintNext_demo", "price" => 20.00, "grams" => 200, "taxable" => false, "inventory_policy" => "continue");
					$thisVar['attributes'] = array("color" => $color['name']);
					$variantArr[] = $thisVar;
				}
			}
			$productImages = array();
			foreach ($productData['data']['store_images'] as $position => $image) {
				$productImages[] = array("src" => $image['src'], "position" => $position+1);
			}

			//mapping the product all options data into an array
			foreach($optionsArr as $productOptions) {
                $optionsArrayData[] = "{name: \"" . strtolower($productOptions['name']) . "\", position: {$productOptions['position']}, values: {name: \"{$productOptions['values'][0]}\"} }";
            }
			$optionSet = "[" . implode(",", $optionsArrayData) . "]";
			 
			//mapping the product all image into an array
			foreach ($productImages as $image) {
				$imageArray[] = "{originalSource: \"{$image['src']}\", mediaContentType: IMAGE}";
			 }
			 $imageSet = "[" . implode(",", $imageArray) . "]";

           //creating the demo product with a single variant, as graphql query does not providing multiple variant creation on a single query
			$createProductQuery = <<<JSON
                        mutation createProduct {
                         productCreate(
                             input: {title: "{$productTitle}", descriptionHtml: "<strong>This is a dummy product, created during imprintNext installation.</strong>", vendor: "test", productType: "imprintNext_demo", handle: "$prodHndlName", productOptions: $optionSet}
                              media: $imageSet
                                )   {
                                product {
                                  id
                               }
                           }
                       }
            JSON;
		    $newlyCreatedProduct = $this->graphQlRequest($createProductQuery);
			$thisProductID = $newlyCreatedProduct['data']['productCreate']['product']['id'];
			
			foreach($variantArr as $eachVar) {
				$graphString = array();
				foreach($eachVar['attributes'] as $attrKey => $eachAttr) {
					$graphString[] = "{name: \"{$eachAttr}\", optionName: \"{$attrKey}\"}";
				}
				$variantSet = "[" . implode(",", $graphString) . "]";
				$varinatsArray[] = "{price:  \"{$eachVar['price']}\", inventoryPolicy: CONTINUE, optionValues: $variantSet, inventoryItem: {tracked: true, sku: \"{$eachVar['sku']}\", measurement: {weight: {value: {$eachVar['grams']}, unit: GRAMS}}}}";
				$finalDataSet = "[" . implode(",", $varinatsArray) . "]";
			}

			// updating the product with all the variants
	        $variantBulkQuery = <<<JSON
                                       mutation variantsBulk {
                                           productVariantsBulkCreate(
                                                 productId: "$thisProductID"
                                                 strategy: REMOVE_STANDALONE_VARIANT
                                                 variants: $finalDataSet 
												) 
												 {
													userErrors {
						          					message
												    }
											}
										}
JSON;

           $this->graphQlRequest($variantBulkQuery);

		   //adding the product to the online store sales channel i.e publishing the product
			$publishQuery = <<<JSON
								mutation starts {
									publishablePublish(
										id: "{$thisProductID}"
										input: {publicationId: "{$this->getPublicationId()}"}
									) {
										userErrors {
										message
										}
									}
								}
							JSON;
			$this->graphQlRequest($publishQuery);
		}
		$this->assignProductToCollection($this->getNumericData($thisProductID));
		$this->setBoundaryForDummyProduct($dom, $this->getNumericData($thisProductID), $productData['data'], $printMethods);
	}

	private function getContentByCURL($Url) {
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_URL, $Url);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    $output = curl_exec($ch);
	    curl_close($ch);
	    return $output;
	}

	private function setBoundaryForDummyProduct($dom, $newProductID, $ParentData,$printMethods) {
		$host = $dom->getElementsByTagName('host')->item(0)->nodeValue;
		$user = $dom->getElementsByTagName('dbuser')->item(0)->nodeValue;
		$password = $dom->getElementsByTagName('dbpass')->item(0)->nodeValue;
		$dbName = $dom->getElementsByTagName('dbname')->item(0)->nodeValue;
		$port = $dom->getElementsByTagName('port')->item(0)->nodeValue;
		
		try {
	        error_reporting(0);
	        if (isset($port) && $port != '') {
	            $conn = new mysqli($host, $user, $password, $dbName, $port);
	        } else {
	            $conn = new mysqli($host, $user, $password);
	            $conn->select_db($dbName);
	        }
	    } catch (Exception $e) {
	        $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Database Connection failed: ' . $e->getMessage() . "\n");
	        return array("proceed_next" => false, "message" => "DATABASE_CONN_ERROR");
	        
	    }
	    // Insert product id into product_setting table and get xe_id
	    $insertProductSetting = "INSERT INTO product_settings(product_id,is_variable_decoration,is_ruler,is_crop_mark,is_safe_zone,crop_value,safe_value,is_3d_preview,3d_object_file,3d_object,scale_unit_id,store_id) VALUES(".$newProductID."," . $ParentData['is_variable_decoration'] ."," . $ParentData['is_ruler']. "," . $ParentData['is_crop_mark']. "," . $ParentData['is_safe_zone']. "," . $ParentData['crop_value']. "," . $ParentData['safe_value']. "," . $ParentData['is_3d_preview']. ",'" . $ParentData['3d_object_file']. "','" . $ParentData['3d_object']. "'," . $ParentData['scale_unit_id']. " , 1)";
        $conn->query($insertProductSetting);
        $prodSetID = mysqli_insert_id($conn);
        
        //Assign product image
        $productimageQRY = "INSERT INTO `product_image_settings_rel` (`product_setting_id`, `product_image_id`) VALUES (".$prodSetID."," . $ParentData['product_image_id'] .")";
        $conn->query($productimageQRY);
        // insert print profile and product id relationship
        $insertRelation = "INSERT INTO print_profile_product_setting_rel(print_profile_id, product_setting_id) VALUES";
        foreach ($printMethods as $key => $rel) {
        	if ($key > 0) {
        		$insertRelation .= ", "; 
        	}
        	 $insertRelation .= "(".$rel."," . $prodSetID. ")";
        }
        $conn->query($insertRelation);

        // Insert sides into product_sides table and get side id
        foreach ($ParentData['sides'] as $side) {
		    $insertSideSetting = "INSERT INTO product_sides(product_setting_id,side_name,side_index,product_image_dimension,is_visible,product_image_side_id) VALUES(".$prodSetID.",'" . $side['name'] ."','" . $side['index']. "','" . $side['dimension']. "'," . $side['is_visible']. "," . $side['image']['id']. ")";
	        $conn->query($insertSideSetting);
	        $sideSetID = mysqli_insert_id($conn);
	        
	        $setting = $side['decoration_settings'][0];
	        // Insert data for each sides decoration settings
	        $insertDecoSetting = "INSERT INTO product_decoration_settings(product_setting_id,product_side_id,name,dimension,print_area_id,sub_print_area_type,custom_min_height,custom_max_height,custom_min_width,custom_max_width,is_border_enable,is_sides_allow) VALUES(".$prodSetID."," . $sideSetID .",'" . $setting['name']. "','" . $setting['dimension']. "','" . $setting['print_area_id']. "','" . $setting['sub_print_area_type']. "','" . $setting['min_height']."','" . $setting['max_height']."','" . $setting['min_width']."','" . $setting['max_width']."','" . $setting['is_border_enable']."','" . $setting['is_sides_allow']. "')";
	        $conn->query($insertDecoSetting);
	        $decoSetID = mysqli_insert_id($conn);

	        $insertMethodSetRel = "INSERT INTO print_profile_decoration_setting_rel(print_profile_id, decoration_setting_id) VALUES";
	        foreach ($printMethods as $key => $rel) {
	        	if ($key > 0) {
	        		$insertMethodSetRel .= ", "; 
	        	}
	        	 $insertMethodSetRel .= "(".$rel."," . $decoSetID. ")";
	        }
	        $conn->query($insertMethodSetRel);
        }

	}

	public function getStoreLangCurrency($storeId, $dom){
	    $aoiUSER= $dom->getElementsByTagName('apiuser')->item(0)->nodeValue;
        $apiPASS= $dom->getElementsByTagName('apipass')->item(0)->nodeValue;
        $appSECRET= $dom->getElementsByTagName('secretkey')->item(0)->nodeValue;
        $shop = $dom->getElementsByTagName('shop')->item(0)->nodeValue;
        $apiVersion = $dom->getElementsByTagName('apiVersion')->item(0)->nodeValue;
        //below 3 should be shifted to store.inc.php after qa testing
        $domain = $shop . '.myshopify.com';
        // $shopURL= 'https://' . $domain;
        // $shopAPIURL= $shopURL . '/admin/oauth/access_token';
        // $shopifyPath = str_replace(SETUPFOLDERNAME.DS, '', ROOTABSPATH).SETUPFOLDERNAME.DS."shopify".DS;

        $shopify = new ShopifyClient($domain, $apiPASS, $aoiUSER, $appSECRET, $apiVersion);
        $shopData = $shopify->call('GET', '/admin/shop.json');
        $storeInfo = array("currency"=> $shopData['currency'], "language"=> $shopData['primary_locale'], "storeId" => 1);
        return json_encode($storeInfo);
	}
}

?>