-- Add new column second_question_id in  admin_users table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'admin_users'
        AND table_schema = DATABASE()
        AND column_name IN('second_question_id')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `admin_users` ADD `second_question_id` INT(10) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column second_answer in  admin_users table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'admin_users'
        AND table_schema = DATABASE()
        AND column_name IN('second_answer')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `admin_users` ADD `second_answer` TEXT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Change 'question_id' column name to 'first_question_id' in  admin_users table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'admin_users'
        AND table_schema = DATABASE()
        AND column_name IN('first_question_id')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `admin_users` CHANGE `question_id` `first_question_id` INT(10) DEFAULT '0' NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Change 'answer' column name to 'first_answer' in  admin_users table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'admin_users'
        AND table_schema = DATABASE()
        AND column_name IN('first_answer')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `admin_users` CHANGE `answer` `first_answer` TEXT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column is_custom_size in  product_settings table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_settings'
        AND table_schema = DATABASE()
        AND column_name IN('is_custom_size')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `product_settings` ADD `is_custom_size` TINYINT(1) DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Insert parent category relations in the print_profile_assets_category_rel table

INSERT INTO `print_profile_assets_category_rel` (`print_profile_id`, `asset_type_id`, `category_id`)
SELECT 1, 3, 1
FROM DUAL
WHERE NOT EXISTS (SELECT `print_profile_id` FROM `print_profile_assets_category_rel` where `print_profile_id`=1 and `asset_type_id`=3 and `category_id`=1);

INSERT INTO `print_profile_assets_category_rel` (`print_profile_id`, `asset_type_id`, `category_id`)
SELECT 1, 3, 2
FROM DUAL
WHERE NOT EXISTS (SELECT `print_profile_id` FROM `print_profile_assets_category_rel` where `print_profile_id`=1 and `asset_type_id`=3 and `category_id`=2);

INSERT INTO `print_profile_assets_category_rel` (`print_profile_id`, `asset_type_id`, `category_id`)
SELECT 1, 3, 3
FROM DUAL
WHERE NOT EXISTS (SELECT `print_profile_id` FROM `print_profile_assets_category_rel` where `print_profile_id`=1 and `asset_type_id`=3 and `category_id`=3);

INSERT INTO `print_profile_assets_category_rel` (`print_profile_id`, `asset_type_id`, `category_id`)
SELECT 1, 3, 4
FROM DUAL
WHERE NOT EXISTS (SELECT `print_profile_id` FROM `print_profile_assets_category_rel` where `print_profile_id`=1 and `asset_type_id`=3 and `category_id`=4);

INSERT INTO `print_profile_assets_category_rel` (`print_profile_id`, `asset_type_id`, `category_id`)
SELECT 1, 3, 5
FROM DUAL
WHERE NOT EXISTS (SELECT `print_profile_id` FROM `print_profile_assets_category_rel` where `print_profile_id`=1 and `asset_type_id`=3 and `category_id`=5);

INSERT INTO `print_profile_assets_category_rel` (`print_profile_id`, `asset_type_id`, `category_id`)
SELECT 2, 3, 1
FROM DUAL
WHERE NOT EXISTS (SELECT `print_profile_id` FROM `print_profile_assets_category_rel` where `print_profile_id`=2 and `asset_type_id`=3 and `category_id`=1);

INSERT INTO `print_profile_assets_category_rel` (`print_profile_id`, `asset_type_id`, `category_id`)
SELECT 2, 3, 2
FROM DUAL
WHERE NOT EXISTS (SELECT `print_profile_id` FROM `print_profile_assets_category_rel` where `print_profile_id`=2 and `asset_type_id`=3 and `category_id`=2);

INSERT INTO `print_profile_assets_category_rel` (`print_profile_id`, `asset_type_id`, `category_id`)
SELECT 2, 3, 3
FROM DUAL
WHERE NOT EXISTS (SELECT `print_profile_id` FROM `print_profile_assets_category_rel` where `print_profile_id`=2 and `asset_type_id`=3 and `category_id`=3);

INSERT INTO `print_profile_assets_category_rel` (`print_profile_id`, `asset_type_id`, `category_id`)
SELECT 2, 3, 4
FROM DUAL
WHERE NOT EXISTS (SELECT `print_profile_id` FROM `print_profile_assets_category_rel` where `print_profile_id`=2 and `asset_type_id`=3 and `category_id`=4);

INSERT INTO `print_profile_assets_category_rel` (`print_profile_id`, `asset_type_id`, `category_id`)
SELECT 2, 3, 5
FROM DUAL
WHERE NOT EXISTS (SELECT `print_profile_id` FROM `print_profile_assets_category_rel` where `print_profile_id`=2 and `asset_type_id`=3 and `category_id`=5);

/*Table structure for table order_item_token */

CREATE TABLE IF NOT EXISTS order_item_token (
  order_id varchar(50) NOT NULL,
  order_item_id varchar(50) NOT NULL,
  token text 
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
/* Add new column uv_file in decoration_objects table */

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'orders'
        AND table_schema = DATABASE()
        AND column_name IN('order_status')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `orders` ADD COLUMN `order_status` VARCHAR(50) NOT NULL DEFAULT 'received';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
/* Add new column sticker_settings in  print_profiles table */

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'print_profiles'
        AND table_schema = DATABASE()
        AND column_name IN('sticker_settings')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `print_profiles` ADD `sticker_settings` TEXT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Update column for module_name in user_privileges table

UPDATE `user_privileges` SET `xe_id`='3',`store_id`='1',`module_name`='Print methods',`status`='1' WHERE `xe_id`='3';
-- Update column for module_name in user_privileges table

UPDATE `user_privileges` SET `xe_id`='3',`store_id`='1',`module_name`='Print methods',`status`='1' WHERE `xe_id`='3';
/* Add new column uv_file in decoration_objects table */

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'decoration_objects'
        AND table_schema = DATABASE()
        AND column_name IN('uv_file')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `decoration_objects` ADD `uv_file` VARCHAR(60) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;