/* Update Settings value for advance settings in settings table */

UPDATE settings SET setting_value = '{"prompt_close_window":true,"price_segregation":true,"progress_wizard":true,"social_share":false,"order_artwork_status":true,"maximum_gallery_size": 200}' WHERE setting_key = 'advance_settings';
-- Add new column custom_size_unit_price in  product_settings table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_settings'
        AND table_schema = DATABASE()
        AND column_name IN('custom_size_unit_price')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `product_settings` ADD `custom_size_unit_price` decimal(6,2) DEFAULT '0.00';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Change 'width' column type in  print_areas table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'print_areas'
        AND table_schema = DATABASE()
        AND column_name IN('width')
    ) < 0,
    "SELECT 1",
	"ALTER TABLE `print_areas` CHANGE `width` `width` VARCHAR(30) DEFAULT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Change 'height' column type in in  print_areas table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'print_areas'
        AND table_schema = DATABASE()
        AND column_name IN('height')
    ) < 0,
    "SELECT 1",
	"ALTER TABLE `print_areas` CHANGE `height` `height` VARCHAR(30) DEFAULT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
/*Table structure for table `product_settings_rel` */
CREATE TABLE IF NOT EXISTS `product_settings_rel` (
  `product_setting_id` int(11) NOT NULL,
  `product_id` varchar(250) NOT NULL,
  `is_3d_preview` tinyint(1) NOT NULL DEFAULT '0',
  `is_product_image` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `product_category_settings_rel` */
CREATE TABLE IF NOT EXISTS `product_category_settings_rel` (
  `product_setting_id` int(11) NOT NULL,
  `product_category_id` varchar(250) NOT NULL,
  `is_3d_preview` tinyint(1) NOT NULL DEFAULT '0',
  `is_product_image` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/* Add new column extra_data in quote_item_files table */

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_item_files'
        AND table_schema = DATABASE()
        AND column_name IN('extra_data')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_item_files ADD extra_data TEXT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
/* Add new column label in app_units table */

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'app_units'
        AND table_schema = DATABASE()
        AND column_name IN('label')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `app_units` ADD COLUMN `label` VARCHAR(20) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

/* Add label values in app_units table */

UPDATE `app_units` SET `label`='in' WHERE `name`='Inch';
UPDATE `app_units` SET `label`='ft' WHERE `name`='Feet';
UPDATE `app_units` SET `label`='cm' WHERE `name`='Centimeter';
UPDATE `app_units` SET `label`='mm' WHERE `name`='Millimeter';
UPDATE `app_units` SET `label`='px' WHERE `name`='Pixel';

/* Insert a new row in app_units table */

INSERT INTO app_units (name, is_default, label)
SELECT 'Meter', '0', 'm'
FROM DUAL
WHERE NOT EXISTS (SELECT name FROM app_units where name='Meter' and label='m');

-- Add new column locations in  product_decoration_settings table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_decoration_settings'
        AND table_schema = DATABASE()
        AND column_name IN('locations')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `product_decoration_settings` ADD `locations` text DEFAULT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;




