-- Datatype is changed for `type` column

ALTER TABLE `design_states` CHANGE `type` `type` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'cart';
-- Table structure for table `email_log` 

CREATE TABLE IF NOT EXISTS `email_log` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `module` varchar(50) NOT NULL,
  `type` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `total_email_count` int(11) NOT NULL,
  `success_email` text NULL,
  `failure_email` text NULL,
  `skipped_email` text NULL,
  `created_date` datetime NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- Add new column customer_name in quotations table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quotations'
        AND table_schema = DATABASE()
        AND column_name IN('customer_name')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quotations ADD customer_name varchar(255) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Add new column customer_email in quotations table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quotations'
        AND table_schema = DATABASE()
        AND column_name IN('customer_email')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quotations ADD customer_email varchar(255) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Add new column customer_availability in quotations table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quotations'
        AND table_schema = DATABASE()
        AND column_name IN('customer_availability')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quotations ADD customer_availability TINYINT(1) NOT NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Add new column attribute in quote_item_variants table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_item_variants'
        AND table_schema = DATABASE()
        AND column_name IN('attribute')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_item_variants ADD attribute TEXT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


