-- Add new column unicode_character in app_currency table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'app_currency'
        AND table_schema = DATABASE()
        AND column_name IN('unicode_character')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE app_currency ADD unicode_character VARCHAR(15) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

UPDATE `app_currency` SET `unicode_character` = '&#36' WHERE `app_currency`.`xe_id` = 1;
UPDATE `app_currency` SET `unicode_character` = '&#8377' WHERE `app_currency`.`xe_id` = 2;
UPDATE `app_currency` SET `unicode_character` = '&#75' WHERE `app_currency`.`xe_id` = 3;
UPDATE `app_currency` SET `unicode_character` = '&#36' WHERE `app_currency`.`xe_id` = 4;
UPDATE `app_currency` SET `unicode_character` = '&#165' WHERE `app_currency`.`xe_id` = 5;
UPDATE `app_currency` SET `unicode_character` = '&#36' WHERE `app_currency`.`xe_id` = 6;
UPDATE `app_currency` SET `unicode_character` = '&#78' WHERE `app_currency`.`xe_id` = 7;
UPDATE `app_currency` SET `unicode_character` = '&#107' WHERE `app_currency`.`xe_id` = 8;
UPDATE `app_currency` SET `unicode_character` = '&#8369' WHERE `app_currency`.`xe_id` = 9;
UPDATE `app_currency` SET `unicode_character` = '&#3647' WHERE `app_currency`.`xe_id` = 10;
UPDATE `app_currency` SET `unicode_character` = '&#1088' WHERE `app_currency`.`xe_id` = 11;
UPDATE `app_currency` SET `unicode_character` = '&#8362' WHERE `app_currency`.`xe_id` = 12;
UPDATE `app_currency` SET `unicode_character` = '&#163' WHERE `app_currency`.`xe_id` = 13;
UPDATE `app_currency` SET `unicode_character` = '&#107' WHERE `app_currency`.`xe_id` = 14;
UPDATE `app_currency` SET `unicode_character` = '&#8364' WHERE `app_currency`.`xe_id` = 15;
UPDATE `app_currency` SET `unicode_character` = '&#36' WHERE `app_currency`.`xe_id` = 16;
UPDATE `app_currency` SET `unicode_character` = '&#122' WHERE `app_currency`.`xe_id` = 17;
UPDATE `app_currency` SET `unicode_character` = '&#67' WHERE `app_currency`.`xe_id` = 18;
UPDATE `app_currency` SET `unicode_character` = '&#36' WHERE `app_currency`.`xe_id` = 19;
UPDATE `app_currency` SET `unicode_character` = '&#36' WHERE `app_currency`.`xe_id` = 20;
UPDATE `app_currency` SET `unicode_character` = '&#107' WHERE `app_currency`.`xe_id` = 21;
UPDATE `app_currency` SET `unicode_character` = '&#36' WHERE `app_currency`.`xe_id` = 22;
UPDATE `app_currency` SET `unicode_character` = '&#70' WHERE `app_currency`.`xe_id` = 23;
UPDATE `app_currency` SET `unicode_character` = '&#165' WHERE `app_currency`.`xe_id` = 24;
-- Add new column order_number in orders table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'orders'
        AND table_schema = DATABASE()
        AND column_name IN('order_number')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE orders ADD order_number VARCHAR(50) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Add new column slug in production_status table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'production_status'
        AND table_schema = DATABASE()
        AND column_name IN('slug')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE production_status ADD slug varchar(255) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

UPDATE `production_status` SET `slug` = 'open' WHERE `production_status`.`xe_id` = 1 AND `production_status`.`module_id` = 1;

UPDATE `production_status` SET `slug` = 'rejected' WHERE `production_status`.`xe_id` = 2 AND `production_status`.`module_id` = 1;

UPDATE `production_status` SET `slug` = 'sent' WHERE `production_status`.`xe_id` = 3 AND `production_status`.`module_id` = 1;

UPDATE `production_status` SET `slug` = 'approved' WHERE `production_status`.`xe_id` = 4 AND `production_status`.`module_id` = 1;

UPDATE `production_status` SET `slug` = 'ordered' WHERE `production_status`.`xe_id` = 5 AND `production_status`.`module_id` = 1;


UPDATE `production_status` SET `slug` = REPLACE(LOWER(`status_name`), ' ', '_') WHERE `production_status`.`module_id` = 1 AND `production_status`.`is_default` != '1';

-- Add new column type in purchase_order_status table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'purchase_order_status'
        AND table_schema = DATABASE()
        AND column_name IN('type')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE purchase_order_status ADD type varchar(255) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

UPDATE `purchase_order_status` SET `type` = 'po-sent' WHERE `purchase_order_status`.`xe_id` = 6 AND `purchase_order_status`.`module_id` = 3;

UPDATE `purchase_order_status` SET `type` = 'partially' WHERE `purchase_order_status`.`xe_id` = 7 AND `purchase_order_status`.`module_id` = 3;

UPDATE `purchase_order_status` SET `type` = 'received' WHERE `purchase_order_status`.`xe_id` = 8 AND `purchase_order_status`.`module_id` = 3;

UPDATE `purchase_order_status` SET `type` = 'pending' WHERE `purchase_order_status`.`xe_id` = 9 AND `purchase_order_status`.`module_id` = 3;

UPDATE `purchase_order_status` SET `type` = REPLACE(LOWER(`status_name`), ' ', '-') WHERE `purchase_order_status`.`module_id` = 3 AND `purchase_order_status`.`is_default` != '1';




-- Add new column is_variable_decoration in quote_items table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_items'
        AND table_schema = DATABASE()
        AND column_name IN('is_variable_decoration')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_items ADD is_variable_decoration TINYINT(1) NULL COMMENT '0-not a vdp, 1- vdp';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column is_custom_size in quote_items table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_items'
        AND table_schema = DATABASE()
        AND column_name IN('is_custom_size')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_items ADD is_custom_size TINYINT(1) NULL COMMENT '0-not custom size, 1- custom size';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column custom_size_dimension in quote_items table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_items'
        AND table_schema = DATABASE()
        AND column_name IN('custom_size_dimension')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_items ADD custom_size_dimension VARCHAR(100) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column custom_size_dimension_unit in quote_items table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_items'
        AND table_schema = DATABASE()
        AND column_name IN('custom_size_dimension_unit')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_items ADD custom_size_dimension_unit VARCHAR(50) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Insert quote_pdf_download in production_template_abbriviations 

INSERT INTO  production_template_abbriviations (abbr_name, module_id)  
SELECT '{quote_pdf_download}', '1' FROM DUAL WHERE NOT EXISTS (SELECT * FROM production_template_abbriviations WHERE abbr_name='{quote_pdf_download}' AND module_id=1);





CREATE TABLE IF NOT EXISTS `product_configurator` (
 `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
 `product_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
 `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
 `price` decimal(6,2) DEFAULT NULL,
 PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `product_configurator_sides` (
 `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
 `section_id` bigint(20) DEFAULT NULL,
 `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
 `side_path_obj` text COLLATE utf8_unicode_ci,
 `preview_file` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
 `svg_file` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
 PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_settings'
        AND table_schema = DATABASE()
        AND column_name IN('is_svg_configurator')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `product_settings` ADD `is_svg_configurator` TINYINT(1) NOT NULL DEFAULT '0' AFTER `custom_size_unit_price`;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;