-- Add new column for image overlay feature

SET @s = (SELECT IF(
    (SELECT COUNT(*)  
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_sides'
        AND table_schema = DATABASE()
        AND column_name IN('image_overlay')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `product_sides` ADD `image_overlay` TINYINT(1) NULL DEFAULT '0', ADD `multiply_overlay` TINYINT(1) NULL DEFAULT '0', ADD `overlay_file_name` VARCHAR(50) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column for image overlay for variable boundary

SET @s = (SELECT IF(
    (SELECT COUNT(*)  
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_decoration_settings'
        AND table_schema = DATABASE()
        AND column_name IN('image_overlay')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `product_decoration_settings` ADD `image_overlay` TINYINT(1) NOT NULL DEFAULT '0', ADD `multiply_overlay` TINYINT(1) NOT NULL DEFAULT '0', ADD `overlay_file_name` VARCHAR(50) NULL DEFAULT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- Table structure for table `transactions` for kiosk payment 

CREATE TABLE IF NOT EXISTS `transactions` (
  `xe_id` int(11) NOT NULL,
  `order_id` varchar(9) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `transaction_id` varchar(254) NOT NULL,
  `payment_mode` varchar(255) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
-- Add new column order_number in orders table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'orders'
        AND table_schema = DATABASE()
        AND column_name IN('order_number')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE orders ADD order_number VARCHAR(50) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

CREATE TABLE IF NOT EXISTS `product_configurator` (
 `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
 `product_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
 `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
 `price` decimal(6,2) DEFAULT NULL,
 PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


CREATE TABLE IF NOT EXISTS `product_configurator_sides` (
 `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
 `section_id` bigint(20) DEFAULT NULL,
 `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
 `side_path_obj` text COLLATE utf8_unicode_ci,
 `preview_file` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
 `svg_file` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
 PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_settings'
        AND table_schema = DATABASE()
        AND column_name IN('is_svg_configurator')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `product_settings` ADD `is_svg_configurator` TINYINT(1) NOT NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Add new column default_stitch_count_per_inch in price_module_settings table

SET @s = (SELECT IF(
    (SELECT COUNT(*)  
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'price_module_settings'
        AND table_schema = DATABASE()
        AND column_name IN('default_stitch_count_per_inch')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE price_module_settings ADD default_stitch_count_per_inch INT(11) NOT NULL DEFAULT '2000';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Insert slug for thread count pricing

INSERT INTO  price_modules (slug, sort_order_index)  
SELECT 'stitch-count', '13' FROM DUAL WHERE NOT EXISTS (SELECT * FROM price_modules WHERE slug='stitch-count' AND sort_order_index=13);


