/*Add 'is_imported' column in cliparts table*/

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'cliparts'
        AND table_schema = DATABASE()
        AND column_name IN('is_imported')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `cliparts` ADD `is_imported` ENUM('0','1') NOT NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


/*Add 'is_imported' column in templates table*/

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'templates'
        AND table_schema = DATABASE()
        AND column_name IN('is_imported')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `templates` ADD `is_imported` ENUM('0','1') NOT NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Delete a row in privileges_sub_modules table

DELETE FROM privileges_sub_modules WHERE slug = 'general' AND user_privilege_id = '4';

-- Add new row in privileges_sub_modules table

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '4', 'General', 'general'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='4' and type='General' and slug='general');