-- Table structure for table `customer_groups` 

CREATE TABLE IF NOT EXISTS `customer_groups` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL,
  `discount_enable` tinyint(0) NOT NULL,
  `discount_type` enum('flat','tier') DEFAULT NULL,
  `tier_price_enable` tinyint(1) NOT NULL,
  `flat_discount` float DEFAULT NULL,
  `group_url` varchar(45) DEFAULT NULL,
  `group_address` text DEFAULT NULL,
  `group_img` text DEFAULT NULL,
  `group_primary_email` varchar(45) DEFAULT NULL,
  `group_secondary_email` varchar(45) DEFAULT NULL,
  `group_primary_number` varchar(45) DEFAULT NULL,
  `group_alt_number` varchar(45) DEFAULT NULL,
  `group_fax` varchar(45) DEFAULT NULL,
  `slug` varchar(45) DEFAULT NULL,
  `store_id` int(11) NOT NULL,
  `store_ref_id` varchar(50) DEFAULT NULL,
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Table structure for table `customer_group_relation` 
CREATE TABLE IF NOT EXISTS `customer_group_relation` (
  `customer_id` varchar(50) NOT NULL,
  `customer_group_id` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Table structure for table `customer_group_assets_category_rel` 
CREATE TABLE IF NOT EXISTS `customer_group_assets_category_rel` (
  `customer_group_id` varchar(50) NOT NULL,
  `asset_type_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Table structure for table `customer_group_tier_discount` 
CREATE TABLE IF NOT EXISTS `customer_group_tier_discount` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_group_id` varchar(50) NOT NULL,
  `qty_from` int(11) NOT NULL,
  `qty_to` int(11) NOT NULL,
  `discount_rate` float NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- Add new column is_disable_design in  product_decoration_settings table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_decoration_settings'
        AND table_schema = DATABASE()
        AND column_name IN('is_disable_design')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `product_decoration_settings` ADD `is_disable_design` TINYINT(1) NOT NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Add new column is_selected in quote_payment_methods table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_payment_methods'
        AND table_schema = DATABASE()
        AND column_name IN('is_selected')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_payment_methods ADD is_selected TINYINT(1) NOT NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Set payPal as default payment method in case of upgrade

UPDATE `quote_payment_methods` SET `is_selected` = '1' WHERE `quote_payment_methods`.`xe_id` = 1;


-- Data for the table `quote_payment_methods` 

INSERT INTO quote_payment_methods (store_id, payment_type, payment_mode)
SELECT '1', 'Stripe', 'test'
FROM DUAL
WHERE NOT EXISTS (SELECT payment_type FROM quote_payment_methods  
where payment_type='Stripe');


-- Add new column payment_method_id in quote_payments table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_payments'
        AND table_schema = DATABASE()
        AND column_name IN('payment_method_id')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_payments ADD payment_method_id TINYINT(1) NOT NULL DEFAULT '0' COMMENT '0 in case of other payment mode';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Table structure for table `customer_additional_info` 

CREATE TABLE IF NOT EXISTS `customer_additional_info` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `customer_id` int(11) NULL,
  `customer_email` varchar(255) NULL,
  `stripe_customer_id` varchar(255) NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;





