-- Add new column archive_status in quotations table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quotations'
        AND table_schema = DATABASE()
        AND column_name IN('archive_status')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quotations ADD archive_status TINYINT(1) NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Insert Request Quote in production_hub_modules 

INSERT INTO  production_hub_modules (name)  
SELECT 'Request Quote' FROM DUAL WHERE NOT EXISTS (SELECT * FROM production_hub_modules WHERE name='Request Quote');

-- Delete duplicate data of {quote_total_amount}

-- DELETE FROM `production_template_abbriviations` WHERE `abbr_name` = '{quote_total_amount}' AND `module_id` = 1 AND (SELECT count(*) FROM production_template_abbriviations WHERE abbr_name='{quote_total_amount}' AND module_id=1) > 1;

-- Insert quote_pdf_download in production_template_abbriviations 

INSERT INTO  production_template_abbriviations (abbr_name, module_id)  
SELECT '{quote_total_amount}', '1' FROM DUAL WHERE NOT EXISTS (SELECT * FROM production_template_abbriviations WHERE abbr_name='{quote_total_amount}' AND module_id=1);

-- Insert form_data in production_template_abbriviations 

INSERT INTO  production_template_abbriviations (abbr_name, module_id)  
SELECT '{form_data}', '7' FROM DUAL WHERE NOT EXISTS (SELECT * FROM production_template_abbriviations WHERE abbr_name='{form_data}' AND module_id=7);

-- Insert product_data in production_template_abbriviations 

INSERT INTO  production_template_abbriviations (abbr_name, module_id)  
SELECT '{product_data}', '7' FROM DUAL WHERE NOT EXISTS (SELECT * FROM production_template_abbriviations WHERE abbr_name='{product_data}' AND module_id=7);

-- Insert customer_name in production_template_abbriviations 

INSERT INTO  production_template_abbriviations (abbr_name, module_id)  
SELECT '{customer_name}', '7' FROM DUAL WHERE NOT EXISTS (SELECT * FROM production_template_abbriviations WHERE abbr_name='{customer_name}' AND module_id=7);

-- Insert customer_email in production_template_abbriviations 

INSERT INTO  production_template_abbriviations (abbr_name, module_id)  
SELECT '{customer_email}', '7' FROM DUAL WHERE NOT EXISTS (SELECT * FROM production_template_abbriviations WHERE abbr_name='{customer_email}' AND module_id=7);

-- Insert requested_date in production_template_abbriviations 

INSERT INTO  production_template_abbriviations (abbr_name, module_id)  
SELECT '{requested_date}', '7' FROM DUAL WHERE NOT EXISTS (SELECT * FROM production_template_abbriviations WHERE abbr_name='{requested_date}' AND module_id=7);


-- Data for the table `production_email_templates` 

INSERT INTO production_email_templates (store_id, module_id, template_type_name, subject, message, is_configured)
SELECT '1','7','request_a_quote', 'Quotation request submitted', '<span>Hello,<br><br>A quotation is requested by {customer_name} (email: {customer_email}) on {requested_date}.</span><br><br><div><b>Quotation request information:</b> {form_data}</div><br><div><b>Product information:</b> {product_data}<br><div><span><br>Thank you.</span><br></div></div>', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, template_type_name FROM production_email_templates 
where store_id='1' and module_id='7' and template_type_name='request_a_quote');

