/* Add 'is_category_assigned' column in print_profiles*/ 
  SET @s = (SELECT IF(
    (SELECT COUNT(*)
	    FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'print_profiles'
  		AND table_schema = DATABASE()
  		AND column_name IN('is_category_assigned')
  	 ) > 0,
  	"SELECT 1",
    "ALTER TABLE `print_profiles` ADD `is_category_assigned` TINYINT(1) NULL DEFAULT '1';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Add new column 'last_updated' in catalog_product_rel table

SET @s = (SELECT IF(
    (SELECT COUNT(*)  
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'catalog_product_rel'
        AND table_schema = DATABASE()
        AND column_name IN('last_updated')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `catalog_product_rel` ADD `last_updated` DATETIME NULL COMMENT 'Last updated time'"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- update data type for 'catalog_code' in catalog_product_rel table

SET @s = (SELECT IF(
    (SELECT COUNT(*)  
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'catalog_product_rel'
        AND table_schema = DATABASE()
        AND column_name IN('catalog_code')
    ) > 0,
    "ALTER TABLE `catalog_product_rel` CHANGE `catalog_code` `catalog_code` VARCHAR(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL",
	"SELECT 1"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
/* Add 'asset_available_flag' column in categories*/ 
  SET @s = (SELECT IF(
    (SELECT COUNT(*)
	    FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'categories'
  		AND table_schema = DATABASE()
  		AND column_name IN('asset_available_flag')
  	 ) > 0,
  	"SELECT 1",
    "ALTER TABLE `categories` ADD `asset_available_flag` TINYINT(1) NOT NULL DEFAULT '1';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Alter column safe_value, crop_value in product_settings table

ALTER TABLE `product_settings` CHANGE `safe_value` `safe_value` FLOAT NOT NULL;

ALTER TABLE `product_settings` CHANGE `crop_value` `crop_value` FLOAT NOT NULL;

-- Add new column custom_size in  product_settings table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_settings'
        AND table_schema = DATABASE()
        AND column_name IN('custom_size')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE  product_settings ADD custom_size TEXT NULL DEFAULT NULL "
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Add new column template_name in production_email_templates table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'production_email_templates'
        AND table_schema = DATABASE()
        AND column_name IN('template_name')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE production_email_templates ADD template_name VARCHAR(255) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column is_team_jersey in quote_items table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_items'
        AND table_schema = DATABASE()
        AND column_name IN('is_team_jersey')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_items ADD is_team_jersey TINYINT(1) NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Table structure for table `team_jersey_data` 

CREATE TABLE IF NOT EXISTS `team_jersey_data` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_item_id` int(11) NULL,
  `data` text NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;









/* insert a new row in user_privileges table*/ 

INSERT IGNORE INTO `privileges_sub_modules` (`xe_id`, `user_privilege_id`, `type`, `slug`, `comments`, `is_default`) VALUES (31, 4, 'Integration', 'integration', NULL, 1);
