/* Add 'price_module_settings' column in stitch_count_unit_id*/ 
  SET @s = (SELECT IF(
    (SELECT COUNT(*)
	    FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'price_module_settings'
  		AND table_schema = DATABASE()
  		AND column_name IN('stitch_count_unit_id')
  	 ) > 0,
  	"SELECT 1",
    "ALTER TABLE `price_module_settings` ADD `stitch_count_unit_id` TINYINT(5) NULL DEFAULT 1;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter price_module_settings table default_stitch_count_per_inch column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'price_module_settings'
        ) > 0,
        "ALTER TABLE price_module_settings CHANGE default_stitch_count_per_inch default_stitch_count_per_inch VARCHAR(30) NULL DEFAULT '2000';",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column xe_id in  decoration_objects table and set as primary key

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'decoration_objects'
        AND table_schema = DATABASE()
        AND column_name IN('xe_id')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `decoration_objects` ADD `xe_id` INT NOT NULL AUTO_INCREMENT FIRST, ADD PRIMARY KEY (`xe_id`)"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Alter product_settings table custom_size_unit_price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'product_settings'
        ) > 0,
        "ALTER TABLE product_settings CHANGE custom_size_unit_price custom_size_unit_price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter product_configurator table price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'product_configurator'
        ) > 0,
        "ALTER TABLE product_configurator CHANGE price price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter transactions table amount column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'transactions'
        ) > 0,
        "ALTER TABLE transactions CHANGE amount amount DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter attribute_price_rules table price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'attribute_price_rules'
        ) > 0,
        "ALTER TABLE attribute_price_rules CHANGE price price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter product_section_images table price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'product_section_images'
        ) > 0,
        "ALTER TABLE product_section_images CHANGE price price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter price_tier_values table setup_cost column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'price_tier_values'
        ) > 0,
        "ALTER TABLE price_tier_values CHANGE setup_cost setup_cost DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter price_tier_values table screen_cost column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'price_tier_values'
        ) > 0,
        "ALTER TABLE price_tier_values CHANGE screen_cost screen_cost DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter print_profile_pricings table setup_price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'print_profile_pricings'
        ) > 0,
        "ALTER TABLE print_profile_pricings CHANGE setup_price setup_price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter price_default_settings table price_value column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'price_default_settings'
        ) > 0,
        "ALTER TABLE price_default_settings CHANGE price_value price_value DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter price_advanced_price_settings table min_price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'price_advanced_price_settings'
        ) > 0,
        "ALTER TABLE price_advanced_price_settings CHANGE min_price min_price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter price_tier_whitebases table price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'price_tier_whitebases'
        ) > 0,
        "ALTER TABLE price_tier_whitebases CHANGE price price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter backgrounds table price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'backgrounds'
        ) > 0,
        "ALTER TABLE backgrounds CHANGE price price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter cliparts table price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'cliparts'
        ) > 0,
        "ALTER TABLE cliparts CHANGE price price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter color_palettes table price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'color_palettes'
        ) > 0,
        "ALTER TABLE color_palettes CHANGE price price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter fonts table price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'fonts'
        ) > 0,
        "ALTER TABLE fonts CHANGE price price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter graphic_fonts table price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'graphic_fonts'
        ) > 0,
        "ALTER TABLE graphic_fonts CHANGE price price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter print_areas table price column type

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'print_areas'
        ) > 0,
        "ALTER TABLE print_areas CHANGE price price DECIMAL(20,8) NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Set name as 'Team jersey' in case of upgrade

UPDATE `features` SET `name` = 'Team jersey' WHERE `name` = 'Team Jearsy';

-- Set name as 'Use from templates' in case of upgrade

UPDATE `features` SET `name` = 'Use from templates' WHERE `name` = 'Use from Templates';

-- Set name as 'Add text' in case of upgrade

UPDATE `features` SET `name` = 'Add text' WHERE `name` = 'Add Text';

-- Set name as 'QR code' in case of upgrade

UPDATE `features` SET `name` = 'QR code' WHERE `name` = 'QR Code';




-- Add new row in privileges_sub_modules table

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '7', 'Customer group', 'customer_group'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='7' and type='Customer group' and slug='customer_group');

-- Add new row in privileges_sub_modules table

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '8', 'Quotation settings', 'quotation_settings'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='8' and type='Quotation settings' and slug='quotation_settings');

-- Add new row in privileges_sub_modules table

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '9', 'Purchase order settings', 'po_settings'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='9' and type='Purchase order settings' and slug='po_settings');

-- Add new row in privileges_sub_modules table

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '11', 'Production settings', 'production_settings'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='11' and type='Production settings' and slug='production_settings');
-- Add new column is_increment in  product_settings table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_settings'
        AND table_schema = DATABASE()
        AND column_name IN('is_increment')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE  product_settings ADD is_increment TINYINT(1) NOT NULL DEFAULT '0' "
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column increment_values in  product_settings table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_settings'
        AND table_schema = DATABASE()
        AND column_name IN('increment_values')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE  product_settings ADD increment_values TEXT "
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Add new row in production_hub_settings table

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '1', 'is_add_multiple_line_item', 'false', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings  
where store_id='1' and module_id='1' and setting_key='is_add_multiple_line_item');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '1', 'is_shipping_cost_enable', 'true', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings  
where store_id='1' and module_id='1' and setting_key='is_shipping_cost_enable');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '1', 'is_tax_enable', 'true', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings  
where store_id='1' and module_id='1' and setting_key='is_tax_enable');

-- Add new column currency_id in quotations table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quotations'
        AND table_schema = DATABASE()
        AND column_name IN('currency_id')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quotations ADD currency_id INT(11) NULL DEFAULT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add default value to settings table

INSERT INTO settings (setting_key, setting_value, type, store_id)
SELECT 'is_email_settings_enabled', '0', '1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT setting_key, setting_value, type FROM settings 
where setting_key='is_email_settings_enabled' AND type='1' AND store_id='1');

-- Update currency data

UPDATE `app_currency` SET `name` = 'Swiss Franc', `unicode_character` = 'CHF' WHERE `app_currency`.`xe_id` = 18;

-- Insert a new row in languages table  

INSERT INTO languages (`name`, `store_id`, `file_name`, `flag`, `type`, `is_enable`, `is_default`)
SELECT 'Romanian', '1', 'lang_romanian.json', 'romanian.png', 'tool', 0, 0
FROM DUAL
WHERE NOT EXISTS (SELECT name FROM languages where name='Romanian' and file_name='lang_romanian.json' and type='tool');

-- Insert a new row in languages table  

INSERT INTO languages (`name`, `store_id`, `file_name`, `flag`, `type`, `is_enable`, `is_default`)
SELECT 'Romanian', '1', 'lang_romanian.json', 'romanian.png', 'admin', 0, 0
FROM DUAL
WHERE NOT EXISTS (SELECT name FROM languages where name='Romanian' and file_name='lang_romanian.json' and type='admin');

-- Insert a new row in app_currency table  

INSERT INTO app_currency (`xe_id`, `name`, `symbol`, `code`, `is_default`, `unicode_character`)
SELECT '25', 'South African Rand', 'R', 'ZAR', '0', 'R'
FROM DUAL
WHERE NOT EXISTS (SELECT xe_id, name FROM app_currency
where xe_id='25' and name='South African Rand');

-- Insert a new row in app_currency table 

INSERT INTO app_currency (`xe_id`, `name`, `symbol`, `code`, `is_default`, `unicode_character`)
SELECT '26', 'Romanian Leu', 'lei', 'RON', '0', 'lei'
FROM DUAL
WHERE NOT EXISTS (SELECT xe_id, name FROM app_currency
where xe_id='26' and name='Romanian Leu');
-- Table structure for table `product_options` 

CREATE TABLE IF NOT EXISTS `product_options` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Table structure for table `product_option_rel`

CREATE TABLE IF NOT EXISTS `product_option_rel` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(50) NOT NULL,
  `option_id` int(11) NOT NULL,
  `option_values` longtext COLLATE utf8_unicode_ci,
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'sort position',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- Table structure for table `product_variants`

CREATE TABLE IF NOT EXISTS `product_variants` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text COLLATE utf8_unicode_ci,
  `price` decimal(10,2) NOT NULL,
  `sku` varchar(50) NOT NULL,
  `image_id` int(11) DEFAULT NULL,
  `barcode` varchar(100) DEFAULT NULL,
  `inventory` int(11) NOT NULL,
  `weight` decimal(10,2) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Table structure for table `product_variant_rel`

CREATE TABLE IF NOT EXISTS `product_variant_rel` (
  `variant_id` int(11) NOT NULL,
  `product_id` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/* Add 'dnt_inventory' column in product_settings table */ 
SET @s = (SELECT IF(
    (SELECT COUNT(*)
	    FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'product_settings'
  		AND table_schema = DATABASE()
  		AND column_name IN('dnt_inventory')
  	 ) > 0,
  	"SELECT 1",
    "ALTER TABLE `product_settings` ADD `dnt_inventory` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '0=track inventory, 1=do not track inventory'"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

/* Add 'custom_variant' column in product_settings table */ 
SET @s = (SELECT IF(
    (SELECT COUNT(*)
	    FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'product_settings'
  		AND table_schema = DATABASE()
  		AND column_name IN('custom_variant')
  	 ) > 0,
  	"SELECT 1",
    "ALTER TABLE `product_settings` ADD `custom_variant` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '0=store, 1=custom'"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;