-- Add 'price_cal_type' column in price_advanced_price_settings
  SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'price_advanced_price_settings'
        AND table_schema = DATABASE()
        AND column_name IN('price_cal_type')
     ) > 0,
    "SELECT 1",
    "ALTER TABLE `price_advanced_price_settings` ADD `price_cal_type` VARCHAR(30) NULL DEFAULT NULL COMMENT 'design area price calculation type.';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
INSERT INTO `settings` (`setting_key`, `setting_value`, `type`, `store_id`) VALUES ('order_blank_products', '{\"is_enabled\":false}', '5', '1'),('aspect_ratio', '{\"is_enabled\":false,\"message\":\"By enabling this option, user can able to scale from four direction of the image\"}', '3', '1');
/* Add 'import_id' column in categories to maintain status flag*/ 
  SET @s = (SELECT IF(
    (SELECT COUNT(*)
	    FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'categories'
  		AND table_schema = DATABASE()
  		AND column_name IN('import_id')
  	 ) > 0,
  	"SELECT 1",
    "ALTER TABLE `categories` ADD `import_id` INT(11) NOT NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Alter column user_type in production_job_log table

ALTER TABLE `production_job_log` CHANGE `user_type` `user_type` VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'admin, customer, agent, operator';


-- Alter column production_status in orders table changing enum to tinyint so first change to char than to tinyint

ALTER TABLE `orders` CHANGE `production_status` `production_status` char(1) NOT NULL DEFAULT 0 COMMENT '0-Not started, 1-In-Progress, 2-Completed';

ALTER TABLE `orders` CHANGE `production_status` `production_status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0-Not started, 1-In-Progress, 2-Completed';



-- Add new row in production_hub_settings table

INSERT INTO `production_hub_settings` (`xe_id`, `store_id`, `module_id`, `setting_key`, `setting_value`, `flag`)
SELECT NULL, '1', '1', 'is_show_dashboard_quotes', 'false', '0' FROM DUAL WHERE NOT EXISTS (SELECT * FROM production_hub_settings WHERE setting_key='is_show_dashboard_quotes' AND module_id='1');


-- Alter shipping_type datatype to varchar from enum

ALTER TABLE `quotations` CHANGE `shipping_type` `shipping_type` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL;

-- Alter user_id datatype to varchar from int

ALTER TABLE `quote_log` CHANGE `user_id` `user_id` VARCHAR(50) NULL DEFAULT NULL COMMENT 'i.e agent data in case of agent assignment';

-- Add new column product_type in quote_items table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_items'
        AND table_schema = DATABASE()
        AND column_name IN('product_type')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_items ADD product_type VARCHAR(20) NULL DEFAULT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Alter customer_id datatype to varchar from int

ALTER TABLE `customer_additional_info` CHANGE `customer_id` `customer_id` VARCHAR(50) NULL DEFAULT NULL;

-- Add new column is_sticker in quote_items table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_items'
        AND table_schema = DATABASE()
        AND column_name IN('is_sticker')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_items ADD is_sticker TINYINT(1) NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Table structure for table `quote_sticker_data` 

CREATE TABLE IF NOT EXISTS `quote_sticker_data` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_item_id` int(11) NULL,
  `data` text NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET @s = (SELECT IF(
    (SELECT COUNT(*)
	    FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'print_profiles'
  		AND table_schema = DATABASE()
  		AND column_name IN('template_settings')
  	 ) > 0,
  	"SELECT 1",
    "ALTER TABLE `print_profiles` ADD `template_settings` MEDIUMTEXT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;