-- Add new column product_stored_type in  catalog_product_re table
SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'catalog_product_rel'
        AND table_schema = DATABASE()
        AND column_name IN('product_stored_type')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `catalog_product_rel` ADD `product_stored_type` ENUM('store','imprint') NOT NULL DEFAULT 'store' "
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

/* Add 'user_design_settings' column in print_profiles*/ 
  SET @s = (SELECT IF(
    (SELECT COUNT(*)
	    FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'print_profiles'
  		AND table_schema = DATABASE()
  		AND column_name IN('user_design_settings')
  	 ) > 0,
  	"SELECT 1",
    "ALTER TABLE `print_profiles` ADD `user_design_settings` MEDIUMTEXT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Add Arabic data to app_currency table

INSERT INTO app_currency (xe_id, name, symbol, code, is_default, unicode_character)
SELECT 27, 'Arabic', 'ر.س', 'SAR', 0, 'SAR'
FROM DUAL
WHERE NOT EXISTS (SELECT xe_id FROM app_currency 
where xe_id=27);
/* Alter table `asset_type` */
INSERT INTO  asset_types (name, slug)  
SELECT 'Configurator Patterns', 'configurator-patterns' FROM DUAL WHERE NOT EXISTS (SELECT * FROM asset_types WHERE slug='configurator-patterns');


SET @new_asset_type_id = (SELECT xe_id FROM asset_types WHERE slug = 'configurator-patterns');

/* Alter table `categories` */
INSERT INTO `categories` (`asset_type_id`, `parent_id`, `name`, `sort_order`, `is_disable`, `is_default`, `store_id`, `created_at`)
SELECT @new_asset_type_id, '0', 'Premium Pattern', '0', '0', '0', '1', '2024-04-29 10:20:35' FROM DUAL WHERE NOT EXISTS (SELECT * FROM categories WHERE name ='Premium Pattern');


/*Table structure for table `configurator_pattern` */
CREATE TABLE IF NOT EXISTS `configurator_pattern` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) DEFAULT NULL,
  `price` decimal(6,2) DEFAULT NULL,
  `file_name` varchar(60) DEFAULT NULL,
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/*Table structure for table `config_pattern_category_rel` */
CREATE TABLE IF NOT EXISTS `config_pattern_category_rel` (
  `config_pattern_id` bigint(20) DEFAULT NULL,
  `category_id` bigint(20) DEFAULT NULL,
  KEY `config_pattern_category_rel_index_001` (`config_pattern_id`, `category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


/* Alter table `configurator_pattern` */
INSERT INTO `configurator_pattern` (`xe_id`, `name`, `price`, `file_name`, `store_id`, `created_at`)
SELECT '1', 'bricks', 0.00, '202403290643443216.svg', 1, '2024-04-29 09:32:00' FROM DUAL WHERE NOT EXISTS
(SELECT * FROM configurator_pattern WHERE xe_id = '1');

INSERT INTO `configurator_pattern` (`xe_id`, `name`, `price`, `file_name`, `store_id`, `created_at`)
SELECT '2', 'spring', 0.00, '202404080306247981.svg', 1, '2024-04-29 09:32:00' FROM DUAL WHERE NOT EXISTS
(SELECT * FROM configurator_pattern WHERE xe_id = '2');

INSERT INTO `configurator_pattern` (`xe_id`, `name`, `price`, `file_name`, `store_id`, `created_at`)
SELECT '3', 'grain', 0.00, '202404081146041729.svg', 1, '2024-04-29 09:32:00' FROM DUAL WHERE NOT EXISTS
(SELECT * FROM configurator_pattern WHERE xe_id = '3');

INSERT INTO `configurator_pattern` (`xe_id`, `name`, `price`, `file_name`, `store_id`, `created_at`)
SELECT '4', 'spiral', 0.00, '202403250731361997.svg', 1, '2024-04-29 09:32:00' FROM DUAL WHERE NOT EXISTS
(SELECT * FROM configurator_pattern WHERE xe_id = '4');

INSERT INTO `configurator_pattern` (`xe_id`, `name`, `price`, `file_name`, `store_id`, `created_at`)
SELECT '5', 'concrete', 0.00, '202403290253063457.svg', 1, '2024-04-29 09:32:00' FROM DUAL WHERE NOT EXISTS
(SELECT * FROM configurator_pattern WHERE xe_id = '5');


SET @pettern_relation_id = (SELECT xe_id FROM categories WHERE name = 'Premium Pattern');

/* Alter table `config_pattern_category_rel` */
INSERT INTO `config_pattern_category_rel` (`config_pattern_id`, `category_id`)
SELECT '1', @pettern_relation_id FROM DUAL WHERE NOT EXISTS
(SELECT * FROM config_pattern_category_rel WHERE config_pattern_id = '1' AND category_id = @pettern_relation_id);

INSERT INTO `config_pattern_category_rel` (`config_pattern_id`, `category_id`)
SELECT '2', @pettern_relation_id FROM DUAL WHERE NOT EXISTS
(SELECT * FROM config_pattern_category_rel WHERE config_pattern_id = '2' AND category_id = @pettern_relation_id);

INSERT INTO `config_pattern_category_rel` (`config_pattern_id`, `category_id`)
SELECT '3', @pettern_relation_id FROM DUAL WHERE NOT EXISTS
(SELECT * FROM config_pattern_category_rel WHERE config_pattern_id = '3' AND category_id = @pettern_relation_id);

INSERT INTO `config_pattern_category_rel` (`config_pattern_id`, `category_id`)
SELECT '4', @pettern_relation_id FROM DUAL WHERE NOT EXISTS
(SELECT * FROM config_pattern_category_rel WHERE config_pattern_id = '4' AND category_id = @pettern_relation_id);

INSERT INTO `config_pattern_category_rel` (`config_pattern_id`, `category_id`)
SELECT '5', @pettern_relation_id FROM DUAL WHERE NOT EXISTS
(SELECT * FROM config_pattern_category_rel WHERE config_pattern_id = '5' AND category_id = @pettern_relation_id);


/* Add New value Configurator Pattern in asset category */

INSERT INTO `privileges_sub_modules` (`xe_id`,`user_privilege_id`, `type`, `slug`, `comments`, `is_default`) 
SELECT 37,2, 'Configurator Patterns', 'configurator-pattern', NULL, 1 FROM DUAL WHERE NOT EXISTS 
(SELECT * FROM privileges_sub_modules WHERE xe_id='37');
/* Alter table design_states change selected_category_id type to TEXT   */ 

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'design_states'
        ) > 0,
        "ALTER TABLE `design_states` CHANGE `selected_category_id` `selected_category_id` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL;",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
/* Add New value Distress*/

INSERT INTO `privileges_sub_modules` (`xe_id`,`user_privilege_id`, `type`, `slug`, `comments`, `is_default`) 
SELECT 36,2, 'Distress', 'distress', NULL, 1 FROM DUAL WHERE NOT EXISTS 
(SELECT * FROM privileges_sub_modules WHERE xe_id='36');

/* Add New value Distress*/

INSERT INTO `features` (`xe_id`,`asset_type_id`, `name`, `slug`) 
SELECT 13,5, 'Distress', 'distress' FROM DUAL WHERE NOT EXISTS 
(SELECT * FROM features WHERE xe_id='13');
-- Table structure for table `artwork_approval` 

CREATE TABLE IF NOT EXISTS `artwork_approval` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` varchar(50) NOT NULL,
  `order_item_id` TEXT NOT NULL,
  `old_ref_id` int(11) NOT NULL,
  `new_ref_id` int(11) NULL,
  `status` TINYINT(1) NULL COMMENT '0-Artwork updated, 1-Sent for approval, 2- Approved, 3- Rejected',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Table structure for table `artwork_approval_conversations` 

CREATE TABLE IF NOT EXISTS `artwork_approval_conversations` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_artwork_id` varchar(50) NOT NULL,
  `user_type` varchar(50) NOT NULL COMMENT 'admin, customer, agent',
  `user_id` varchar(50) NOT NULL,
  `message` TEXT DEFAULT NULL,
  `seen_flag` TINYINT(1) NULL,
  `created_date` DATETIME NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Table structure for table `artwork_approval_conv_files` 

CREATE TABLE IF NOT EXISTS `artwork_approval_conv_files` (
  `xe_id` INT(11) NOT NULL AUTO_INCREMENT , 
  `conv_id` INT(11) NOT NULL,
  `file` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Add new column artwork_approval_id in order_logs table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'order_logs'
        AND table_schema = DATABASE()
        AND column_name IN('artwork_approval_id')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE order_logs ADD artwork_approval_id INT(11) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
/* Alter table product_image_sides change file_name type to icrease the length-value */ 
SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_NAME = 'product_image_sides'
        ) > 0,
        "ALTER TABLE `product_image_sides` CHANGE `file_name` `file_name` VARCHAR(250);",
        "SELECT 1"
    )
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
/* Alter table product_images Add is_catalog column */ 
SET @s = (SELECT IF(
    (SELECT COUNT(*)
	    FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'product_images'
  		AND table_schema = DATABASE()
  		AND column_name IN('is_catalog')
  	 ) > 0,
  	"SELECT 1",
    "ALTER TABLE `product_images` ADD `is_catalog` TINYINT(1) NOT NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
/* ALTER TABLE `templates` ADD `show_in_tool` */


SET @s = (SELECT IF(
    (SELECT COUNT(*)
	    FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'templates'
  		AND table_schema = DATABASE()
  		AND column_name IN('show_in_tool')
  	 ) > 0,
  	"SELECT 1",
    "ALTER TABLE `templates` ADD `show_in_tool` TINYINT NOT NULL DEFAULT 1;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;