/* Add 'cloud_storage' column in distresses table*/
SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'distresses'
        AND table_schema = DATABASE()
        AND column_name IN('cloud_storage')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `distresses` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column is_tier_total_qty in quote_items table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_items'
        AND table_schema = DATABASE()
        AND column_name IN('is_tier_total_qty')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_items ADD is_tier_total_qty TINYINT(1) NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
/* ALTER TABLE `product_settings` ADD `is_applied_color` */

SET @s = (SELECT IF(
    (SELECT COUNT(*)  
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_settings'
        AND table_schema = DATABASE()
        AND column_name IN('is_applied_color')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `product_settings` ADD `is_applied_color` TINYINT(1) NOT NULL DEFAULT '0'; "
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
/* Add 'template_url' column in templates table*/
SET @s = (SELECT IF(
      (SELECT COUNT(*)
          FROM INFORMATION_SCHEMA.COLUMNS
          WHERE table_name = 'templates'
           AND table_schema = DATABASE()
          AND column_name IN('template_url')
          ) > 0 ,
      "SELECT 1",
      "ALTER TABLE `templates` ADD `template_url` TEXT DEFAULT NULL;"
      ));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

/* Add 'temp_token' column in templates table*/
SET @s = (SELECT IF(
      (SELECT COUNT(*)
          FROM INFORMATION_SCHEMA.COLUMNS
          WHERE table_name = 'templates'
           AND table_schema = DATABASE()
          AND column_name IN('temp_token')
          ) > 0 ,
      "SELECT 1",
      "ALTER TABLE `templates` ADD `temp_token` VARCHAR(50) DEFAULT NULL;"
      ));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;